/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.service.web.interceptor;

import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.jasig.portlet.proxy.service.web.interceptor.AbstractBasicAuthenticationPreInterceptor;
import org.springframework.stereotype.Service;

@Service(value="portletPreferencesBasicAuthenticationPreInterceptor")
public class PortletPreferencesBasicAuthenticationPreInterceptor
extends AbstractBasicAuthenticationPreInterceptor {
    public static final String BEAN_ID = "portletPreferencesBasicAuthenticationPreInterceptor";
    public static final String USERNAME_PREFERENCE = PortletPreferencesBasicAuthenticationPreInterceptor.class.getName() + ".username";
    public static final String PASSWORD_PREFERENCE = PortletPreferencesBasicAuthenticationPreInterceptor.class.getName() + ".password";

    protected UsernamePasswordCredentials getCredentials(PortletRequest portletRequest) {
        PortletPreferences preferences = portletRequest.getPreferences();
        String username = preferences.getValue(USERNAME_PREFERENCE, null);
        String password = preferences.getValue(PASSWORD_PREFERENCE, null);
        if (StringUtils.isBlank((String)username) || StringUtils.isBlank((String)password)) {
            String msg = "Both username and password are required for PortletPreferencesBasicAuthenticationPreInterceptor";
            throw new IllegalStateException("Both username and password are required for PortletPreferencesBasicAuthenticationPreInterceptor");
        }
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
        return credentials;
    }
}

