/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.mvc.portlet.gateway;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.proxy.mvc.IViewSelector;
import org.jasig.portlet.proxy.mvc.portlet.gateway.BaseGatewayPortletController;
import org.jasig.portlet.proxy.mvc.portlet.gateway.GatewayEntry;
import org.jasig.portlet.proxy.service.web.HttpContentRequestImpl;
import org.jasig.portlet.proxy.service.web.IAuthenticationFormModifier;
import org.jasig.portlet.proxy.service.web.interceptor.IPreInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class GatewayPortletController
extends BaseGatewayPortletController {
    private static final String HTTPS = "HTTPS";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource(name="gatewayEntries")
    private List<GatewayEntry> gatewayEntries;
    @Autowired(required=false)
    private String viewName = "gateway";
    @Autowired(required=false)
    private String mobileViewName = "mobileGateway";
    @Autowired(required=true)
    private IViewSelector viewSelector;

    @PostConstruct
    private void validateGatewayEntries() {
        HashSet<GatewayEntry> set = new HashSet<GatewayEntry>();
        for (GatewayEntry entry : this.gatewayEntries) {
            if (set.add(entry)) continue;
            throw new InvalidPropertyException(GatewayEntry.class, "name", "Error initializing Gateway Entries, multiple entries with name " + entry.getName());
        }
    }

    @RenderMapping
    public ModelAndView getView(RenderRequest request) {
        ModelAndView mv = new ModelAndView();
        List entries = this.removeInaccessibleEntries(this.gatewayEntries, (PortletRequest)request);
        HashMap<String, Boolean> validations = new HashMap<String, Boolean>();
        for (GatewayEntry entry : entries) {
            for (Map.Entry requestEntry : entry.getContentRequests().entrySet()) {
                HttpContentRequestImpl contentRequest = (HttpContentRequestImpl)requestEntry.getKey();
                for (IPreInterceptor interceptor : (List)requestEntry.getValue()) {
                    boolean isValid = interceptor.validate(contentRequest, (PortletRequest)request);
                    validations.put(entry.getName(), isValid);
                }
            }
        }
        mv.addObject("entries", (Object)entries);
        mv.addObject("validations", validations);
        String openInNewPage = request.getPreferences().getValue("openInNewPage", "true");
        mv.addObject("openInNewPage", (Object)openInNewPage);
        String view = this.viewSelector.isMobile((PortletRequest)request) ? this.mobileViewName : this.viewName;
        mv.setView((Object)view);
        return mv;
    }

    @ResourceMapping
    public String showTarget(ResourceRequest portletRequest, ResourceResponse portletResponse, Model model, @RequestParam(value="index") String beanName) throws IOException {
        this.prepareGatewayResponse(portletRequest, portletResponse, beanName, model);
        return "json";
    }

    @ResourceMapping(value="showTargetInNewWindow")
    public String showTargetInNewWindow(ResourceRequest portletRequest, ResourceResponse portletResponse, Model model, @RequestParam(value="index") String beanName) throws IOException {
        model.addAttribute("index", (Object)beanName);
        return "gatewayNewPage";
    }

    private void prepareGatewayResponse(ResourceRequest portletRequest, ResourceResponse portletResponse, String beanName, Model model) throws IOException {
        List entries = this.gatewayEntries;
        GatewayEntry entry = this.getAccessibleEntry(entries, (PortletRequest)portletRequest, beanName);
        if (entry == null) {
            return;
        }
        ArrayList<HttpContentRequestImpl> contentRequests = new ArrayList<HttpContentRequestImpl>();
        for (Map.Entry requestEntry : entry.getContentRequests().entrySet()) {
            HttpContentRequestImpl contentRequest = ((HttpContentRequestImpl)requestEntry.getKey()).duplicate();
            for (IPreInterceptor interceptor : (List)requestEntry.getValue()) {
                interceptor.intercept(contentRequest, (PortletRequest)portletRequest);
            }
            contentRequests.add(contentRequest);
        }
        for (IAuthenticationFormModifier authenticationFormModifier : entry.getAuthenticationFormModifier()) {
            for (HttpContentRequestImpl contentRequest : contentRequests) {
                authenticationFormModifier.modifyHttpContentRequest(contentRequest, portletRequest.getPreferences());
            }
        }
        for (HttpContentRequestImpl contentRequest : contentRequests) {
            if (!entry.isRequireSecure() || !StringUtils.isNotBlank((String)contentRequest.getProxiedLocation()) || contentRequest.getProxiedLocation().length() < HTTPS.length() || HTTPS.equalsIgnoreCase(contentRequest.getProxiedLocation().substring(0, HTTPS.length()))) continue;
            this.logger.error("Proxied location '" + contentRequest.getProxiedLocation() + "' for gateway entry " + entry.getName() + " is not secure - discarding entry!!!");
            contentRequest.setParameters(new HashMap());
            contentRequest.setProxiedLocation("/HTTPSUrlRequiredButNotSpecified");
        }
        model.addAttribute("contentRequests", contentRequests);
        model.addAttribute("javascriptFile", (Object)entry.getJavascriptFile());
        portletResponse.setProperty("Cache-Control", "no-cache, no-store, must-revalidate");
        portletResponse.setProperty("Pragma", "no-cache");
        portletResponse.setProperty("Expires", "0");
    }
}

