/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.mvc.portlet.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.io.IOUtils;
import org.apereo.portal.search.SearchConstants;
import org.apereo.portal.search.SearchResults;
import org.jasig.portlet.proxy.search.ISearchService;
import org.jasig.portlet.proxy.service.IContentRequest;
import org.jasig.portlet.proxy.service.IContentResponse;
import org.jasig.portlet.proxy.service.IContentService;
import org.jasig.portlet.proxy.service.proxy.document.IDocumentFilter;
import org.jasig.portlet.proxy.service.web.HttpContentResponseImpl;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.EventMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class ProxyPortletController {
    public static final String PREF_CHARACTER_ENCODING = "sourcePageCharacterEncoding";
    public static final String CHARACTER_ENCODING_DEFAULT = "UTF-8";
    protected static final String CONTENT_SERVICE_KEY = "contentService";
    protected static final String FILTER_LIST_KEY = "filters";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private ApplicationContext applicationContext;
    private final List<Pattern> knownHtmlContentTypes = new ArrayList();
    @Resource(name="contentSearchProvider")
    private ISearchService searchService;

    @Autowired(required=true)
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Required
    @Resource(name="knownHtmlContentTypes")
    public void setKnownHtmlContentTypes(List<String> contentTypes) {
        this.knownHtmlContentTypes.clear();
        for (String contentType : contentTypes) {
            this.knownHtmlContentTypes.add(Pattern.compile(contentType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RenderMapping
    public void showContent(RenderRequest request, RenderResponse response) {
        try (IContentResponse proxyResponse = null;){
            proxyResponse = this.invokeProxy((PortletRequest)request);
            List filters = this.prepareFilters((PortletRequest)request);
            Document document = this.parseDocument((PortletRequest)request, proxyResponse);
            for (IDocumentFilter filter : filters) {
                filter.filter(document, proxyResponse, request, response);
            }
            OutputStream out = null;
            try {
                out = response.getPortletOutputStream();
                IOUtils.write((String)document.html(), (OutputStream)out);
                out.flush();
            }
            catch (IOException e) {
                this.log.error("Exception writing proxied content", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RenderMapping(value="proxy.url")
    public void showProxyContent(RenderRequest request, RenderResponse response) {
        try (IContentResponse proxyResponse = null;){
            proxyResponse = this.invokeProxy((PortletRequest)request);
            List filters = this.prepareFilters((PortletRequest)request);
            Document document = this.parseDocument((PortletRequest)request, proxyResponse);
            for (IDocumentFilter filter : filters) {
                filter.filter(document, proxyResponse, request, response);
            }
            OutputStream out = null;
            try {
                out = response.getPortletOutputStream();
                IOUtils.write((String)document.html(), (OutputStream)out);
                out.flush();
            }
            catch (IOException e) {
                this.log.error("Exception writing proxied content", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ActionMapping
    public void proxyTarget(@RequestParam(value="proxy.url") String url, ActionRequest request, ActionResponse response) throws IOException {
        try (IContentResponse proxyResponse = null;){
            proxyResponse = this.invokeProxy((PortletRequest)request);
            if (proxyResponse instanceof HttpContentResponseImpl) {
                HttpContentResponseImpl httpContentResponse = (HttpContentResponseImpl)proxyResponse;
                String responseContentType = (String)httpContentResponse.getHeaders().get("Content-Type");
                for (Pattern contentType : this.knownHtmlContentTypes) {
                    if (responseContentType == null || !contentType.matcher(responseContentType).matches()) continue;
                    Map params = request.getParameterMap();
                    response.setRenderParameters(params);
                    return;
                }
            }
            PortletSession session = request.getPortletSession();
            ConcurrentMap rewrittenUrls = (ConcurrentMap)session.getAttribute("rewrittenUrls");
            response.sendRedirect((String)rewrittenUrls.get(url));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ResourceMapping
    public void proxyResourceTarget(@RequestParam(value="proxy.url") String url, ResourceRequest request, ResourceResponse response) {
        OutputStream out;
        block7: {
            IContentResponse proxyResponse = null;
            out = null;
            try {
                proxyResponse = this.invokeProxy((PortletRequest)request);
                if (proxyResponse instanceof HttpContentResponseImpl) {
                    HttpContentResponseImpl httpProxyResponse = (HttpContentResponseImpl)proxyResponse;
                    for (Map.Entry header : httpProxyResponse.getHeaders().entrySet()) {
                        response.setProperty((String)header.getKey(), (String)header.getValue());
                    }
                }
                out = response.getPortletOutputStream();
                IOUtils.copyLarge((InputStream)proxyResponse.getContent(), (OutputStream)out);
                out.flush();
                if (proxyResponse == null) break block7;
            }
            catch (IOException e) {
                block8: {
                    try {
                        response.setProperty("portlet.http-status-code", String.valueOf(401));
                        this.log.error("Exception writing proxied content", (Throwable)e);
                        if (proxyResponse == null) break block8;
                    }
                    catch (Throwable throwable) {
                        if (proxyResponse != null) {
                            proxyResponse.close();
                        }
                        IOUtils.closeQuietly(out);
                        throw throwable;
                    }
                    proxyResponse.close();
                }
                IOUtils.closeQuietly((OutputStream)out);
            }
            proxyResponse.close();
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    @EventMapping(value="{https://source.jasig.org/schemas/uportal/search}SearchRequest")
    public void searchRequest(EventRequest request, EventResponse response) {
        this.log.debug("EVENT HANDLER -- START");
        try {
            IContentResponse proxyResponse = this.invokeProxy((PortletRequest)request);
            Document document = this.parseDocument((PortletRequest)request, proxyResponse);
            SearchResults searchResults = this.searchService.search(request, document);
            response.setEvent(SearchConstants.SEARCH_RESULTS_QNAME, (Serializable)searchResults);
        }
        catch (IOException e) {
            throw new RuntimeException("Search request failed", e);
        }
        this.log.debug("EVENT HANDLER -- END");
    }

    private IContentService<IContentRequest, IContentResponse> selectContentService(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        String contentServiceKey = prefs.getValue(CONTENT_SERVICE_KEY, null);
        IContentService rslt = (IContentService)this.applicationContext.getBean(contentServiceKey, IContentService.class);
        return rslt;
    }

    private IContentResponse invokeProxy(PortletRequest req) {
        IContentResponse rslt;
        IContentRequest proxyRequest;
        IContentService contentService = this.selectContentService(req);
        try {
            proxyRequest = contentService.getRequest(req);
        }
        catch (Exception e) {
            throw new RuntimeException("URL was not in the proxy list", e);
        }
        try {
            rslt = contentService.getContent(proxyRequest, req);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to proxy content", e);
        }
        return rslt;
    }

    private List<IDocumentFilter> prepareFilters(PortletRequest req) {
        String[] filterKeys;
        PortletPreferences preferences = req.getPreferences();
        ArrayList<IDocumentFilter> rslt = new ArrayList<IDocumentFilter>();
        for (String filterKey : filterKeys = preferences.getValues(FILTER_LIST_KEY, new String[0])) {
            IDocumentFilter filter = (IDocumentFilter)this.applicationContext.getBean(filterKey, IDocumentFilter.class);
            rslt.add(filter);
        }
        return rslt;
    }

    private Document parseDocument(PortletRequest req, IContentResponse proxyResponse) throws IOException {
        PortletPreferences preferences = req.getPreferences();
        String sourceEncodingFormat = preferences.getValue(PREF_CHARACTER_ENCODING, CHARACTER_ENCODING_DEFAULT);
        Document rslt = Jsoup.parse((InputStream)proxyResponse.getContent(), (String)sourceEncodingFormat, (String)proxyResponse.getProxiedLocation());
        return rslt;
    }
}

