/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.service.web;

import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jasig.portlet.proxy.service.web.IHttpClientService;
import org.jasig.portlet.proxy.service.web.RedirectTrackingResponseInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.portlet.util.PortletUtils;

@Service
public class MultiRequestHttpClientServiceImpl
implements IHttpClientService {
    private static final Logger LOG = LoggerFactory.getLogger(MultiRequestHttpClientServiceImpl.class);
    public static final String HTTP_CLIENT_CONNECTION_TIMEOUT = "httpClientConnectionTimeout";
    public static final String HTTP_CLIENT_CONNECTION_REQUEST_TIMEOUT = "httpClientConnectionRequestTimeout";
    public static final String HTTP_CLIENT_SOCKET_TIMEOUT = "httpClientSocketTimeout";
    public static final int DEFAULT_HTTP_CLIENT_CONNECTION_TIMEOUT = 10000;
    public static final int DEFAULT_HTTP_CLIENT_CONNECTION_REQUEST_TIMEOUT = 5000;
    public static final int DEFAULT_HTTP_CLIENT_SOCKET_TIMEOUT = 10000;
    public static final String CLIENT_SESSION_KEY = "httpClient";
    public static final String SHARED_SESSION_KEY = "sharedSessionKey";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClient getHttpClient(PortletRequest request) {
        HttpClient client;
        PortletSession session = request.getPortletSession();
        PortletPreferences preferences = request.getPreferences();
        String sharedSessionKey = preferences.getValue(SHARED_SESSION_KEY, null);
        int scope = sharedSessionKey != null ? 1 : 2;
        String clientSessionKey = sharedSessionKey != null ? sharedSessionKey : CLIENT_SESSION_KEY;
        Object object = PortletUtils.getSessionMutex((PortletSession)session);
        synchronized (object) {
            client = (HttpClient)session.getAttribute(clientSessionKey, scope);
            if (client == null) {
                client = this.createHttpClient(request);
                session.setAttribute(clientSessionKey, (Object)client, scope);
            }
        }
        return client;
    }

    protected HttpClient createHttpClient(PortletRequest request) {
        PortletPreferences prefs = request.getPreferences();
        int httpClientConnectionTimeout = Integer.parseInt(prefs.getValue(HTTP_CLIENT_CONNECTION_TIMEOUT, String.valueOf(10000)));
        int httpClientConnectionRequestTimeout = Integer.parseInt(prefs.getValue(HTTP_CLIENT_CONNECTION_REQUEST_TIMEOUT, String.valueOf(5000)));
        int httpClientSocketTimeout = Integer.parseInt(prefs.getValue(HTTP_CLIENT_SOCKET_TIMEOUT, String.valueOf(10000)));
        RequestConfig config = RequestConfig.custom().setConnectTimeout(httpClientConnectionTimeout).setConnectionRequestTimeout(httpClientConnectionRequestTimeout).setSocketTimeout(httpClientSocketTimeout).build();
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(config).addInterceptorFirst((HttpResponseInterceptor)new RedirectTrackingResponseInterceptor()).build();
        return client;
    }
}

