/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.service.web.interceptor;

import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.proxy.security.IStringEncryptionService;
import org.jasig.portlet.proxy.service.IFormField;
import org.jasig.portlet.proxy.service.web.HttpContentRequestImpl;
import org.jasig.portlet.proxy.service.web.interceptor.IPreInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="UserPreferencesPreInterceptor")
public class UserPreferencesPreInterceptor
implements IPreInterceptor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String preferencesRegex;
    @Autowired(required=false)
    private IStringEncryptionService stringEncryptionService;

    @Value(value="${login.preferences.regex}")
    public void setPreferencesRegex(String preferencesRegex) {
        this.preferencesRegex = preferencesRegex;
    }

    public void intercept(HttpContentRequestImpl proxyRequest, PortletRequest portletRequest) {
        PortletPreferences prefs = portletRequest.getPreferences();
        Map parameters = proxyRequest.getParameters();
        for (String parameterKey : parameters.keySet()) {
            IFormField parameter = (IFormField)parameters.get(parameterKey);
            String[] parameterValues = parameter.getValues();
            for (int i = 0; i < parameterValues.length; ++i) {
                String parameterValue = parameterValues[i];
                if (!parameterValue.matches(this.preferencesRegex)) continue;
                String preferredValue = prefs.getValue(parameterValue, parameterValue);
                if (parameter.getSecured() && StringUtils.isNotBlank((String)preferredValue) && this.stringEncryptionService != null) {
                    this.logger.debug("decrypting preferredValue '" + preferredValue + "' for parameterKey: '" + parameterKey);
                    preferredValue = this.stringEncryptionService.decrypt(preferredValue);
                }
                parameterValues[i] = preferredValue;
            }
        }
    }

    public boolean validate(HttpContentRequestImpl proxyRequest, PortletRequest portletRequest) {
        boolean allPreferencesSet = true;
        PortletPreferences prefs = portletRequest.getPreferences();
        block0: for (Map.Entry entry : proxyRequest.getParameters().entrySet()) {
            String[] parameterValues;
            IFormField parameter = (IFormField)entry.getValue();
            for (String parameterValue : parameterValues = parameter.getValues()) {
                String preferredValue;
                if (!parameterValue.matches(this.preferencesRegex) || !StringUtils.isBlank((String)(preferredValue = prefs.getValue(parameterValue, null)))) continue;
                allPreferencesSet = false;
                continue block0;
            }
        }
        return allPreferencesSet;
    }
}

