/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.mvc.portlet.utilities;

import java.util.Enumeration;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import org.springframework.stereotype.Component;

@Component
public class ActionScopedRequestAttributeManager {
    public static final String ACTION_SCOPED_REQUEST_PREFIX = "actionScopedRequestAttributePrefix.WebProxyPortlet";

    public void storeItem(PortletRequest request, String key, Object item) {
        request.getPortletSession().setAttribute(ACTION_SCOPED_REQUEST_PREFIX + key, item);
    }

    public Object propogateAndReturnItem(RenderRequest request, String key) {
        return this.propogateAndReturnItem(request, key, true);
    }

    public Object propogateAndReturnItem(RenderRequest request, String key, boolean clearItem) {
        Object item = request.getPortletSession().getAttribute(ACTION_SCOPED_REQUEST_PREFIX + key);
        if (item != null) {
            request.setAttribute(key, item);
            if (clearItem) {
                request.getPortletSession().removeAttribute(ACTION_SCOPED_REQUEST_PREFIX + key);
            }
        }
        return item;
    }

    public void clearAttributes(PortletRequest request) {
        Enumeration attributeNames = request.getPortletSession().getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            if (!attributeName.startsWith(ACTION_SCOPED_REQUEST_PREFIX)) continue;
            request.getPortletSession().removeAttribute(attributeName);
        }
    }
}

