/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.service.web.interceptor;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import javax.portlet.PortletRequest;
import org.jasig.portlet.proxy.service.IFormField;
import org.jasig.portlet.proxy.service.web.HttpContentRequestImpl;
import org.jasig.portlet.proxy.service.web.interceptor.IPreInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="userInfoUrlParameterizingPreInterceptor")
public class UserInfoUrlParameterizingPreInterceptor
implements IPreInterceptor {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void intercept(HttpContentRequestImpl proxyRequest, PortletRequest portletRequest) {
        try {
            String url = proxyRequest.getProxiedLocation();
            Map userInfo = (Map)portletRequest.getAttribute("javax.portlet.userinfo");
            for (String key : userInfo.keySet()) {
                String token;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Checking user attribute {} with value {}", (Object)key, "password".equals(key) ? "length is " + (String)userInfo.get(key) : userInfo.get(key));
                }
                if (url.contains(token = "{".concat(key).concat("}"))) {
                    url = url.replaceAll("\\{".concat(key).concat("\\}"), URLEncoder.encode((String)userInfo.get(key), "UTF-8"));
                    this.log.debug("Token {} found in url and replaced", (Object)key);
                }
                for (Map.Entry<String, IFormField> param : proxyRequest.getParameters().entrySet()) {
                    int length = param.getValue().getValues().length;
                    for (int i = 0; i < length; ++i) {
                        String value = param.getValue().getValues()[i];
                        if (!value.contains(token)) continue;
                        param.getValue().getValues()[i] = value.replaceAll("\\{".concat(key).concat("\\}"), (String)userInfo.get(key));
                        this.log.debug("Token {} found in parameter and replaced", (Object)key);
                    }
                }
            }
            proxyRequest.setProxiedLocation(url);
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("Exception while encoding URL parameters", (Throwable)e);
        }
    }

    @Override
    public boolean validate(HttpContentRequestImpl proxyRequest, PortletRequest portletRequest) {
        return true;
    }
}

