/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.service.web.interceptor;

import java.net.URISyntaxException;
import java.util.Map;
import javax.portlet.PortletRequest;
import org.apache.http.client.utils.URIBuilder;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;
import org.jasig.portlet.proxy.service.web.HttpContentRequestImpl;
import org.jasig.portlet.proxy.service.web.interceptor.AuthenticationPreInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="proxyCASAuthenticationPreInterceptor")
public class ProxyCASAuthenticationPreInterceptor
extends AuthenticationPreInterceptor {
    public static final String BEAN_ID = "proxyCASAuthenticationPreInterceptor";
    private String serviceUrl;
    private TicketValidator ticketValidator;

    @Value(value="${portal.server.base.url}/${portlet.context}")
    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    @Autowired(required=true)
    public void setTicketValidator(TicketValidator ticketValidator) {
        this.ticketValidator = ticketValidator;
    }

    @Override
    protected void prepareAuthentication(HttpContentRequestImpl contentRequest, PortletRequest portletRequest) {
        Map userinfo = (Map)portletRequest.getAttribute("javax.portlet.userinfo");
        String ticket = (String)userinfo.get("casProxyTicket");
        if (ticket == null) {
            this.log.warn("No CAS ticket found in the UserInfo map. Is 'casProxyTicket' user-attribute declared in the portlet configuration?");
            return;
        }
        this.log.debug("serviceURL: {}, ticket: {}", (Object)this.serviceUrl, (Object)ticket);
        try {
            Assertion assertion = this.ticketValidator.validate(ticket, this.serviceUrl);
            String proxyTicket = assertion.getPrincipal().getProxyTicketFor(contentRequest.getProxiedLocation());
            if (proxyTicket == null) {
                this.log.error("Failed to retrieve proxy ticket for assertion [{}]. Is the PGT still valid?", (Object)assertion.toString());
                return;
            }
            this.log.trace("returning from proxy ticket request with proxy ticket [{}]", (Object)proxyTicket);
            URIBuilder builder = new URIBuilder(contentRequest.getProxiedLocation());
            builder.addParameter("ticket", proxyTicket);
            String proxiedLocation = builder.build().toString();
            this.log.debug("Set final proxied location to be {}", (Object)proxiedLocation);
            contentRequest.setProxiedLocation(proxiedLocation);
        }
        catch (TicketValidationException e) {
            this.log.warn("Failed to validate proxy ticket", (Throwable)e);
            return;
        }
        catch (URISyntaxException e) {
            this.log.warn("Failed to parse proxy URL", (Throwable)e);
            return;
        }
    }

    @Override
    public boolean validate(HttpContentRequestImpl proxyRequest, PortletRequest portletRequest) {
        return true;
    }
}

