/*
 * Decompiled with CFR 0.152.
 */
package au.edu.anu.portal.portlets.sakaiconnector.utils;

import au.edu.anu.portal.portlets.sakaiconnector.models.Page;
import au.edu.anu.portal.portlets.sakaiconnector.models.Site;
import au.edu.anu.portal.portlets.sakaiconnector.models.SiteList;
import au.edu.anu.portal.portlets.sakaiconnector.models.SitePageList;
import au.edu.anu.portal.portlets.sakaiconnector.models.Tool;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.core.Persister;

/*
 * Exception performing whole class analysis ignored.
 */
public class XmlParser {
    private static final Log log = LogFactory.getLog(XmlParser.class);

    public static List<Site> parseListOfSites(String xml) {
        if (log.isDebugEnabled()) {
            log.debug((Object)xml);
        }
        Persister serializer = new Persister();
        List<Object> sites = new ArrayList<Site>();
        if (!XmlParser.isValid((Serializer)serializer, SiteList.class, (String)xml)) {
            log.error((Object)("Invalid SiteList: " + xml));
            return sites;
        }
        try {
            SiteList list = (SiteList)serializer.read(SiteList.class, xml);
            sites = list.getSites();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Num sites found: " + sites.size()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sites;
    }

    public static List<Tool> parseListOfPages(String xml) {
        if (log.isDebugEnabled()) {
            log.debug((Object)xml);
        }
        Persister serializer = new Persister();
        ArrayList<Tool> tools = new ArrayList<Tool>();
        if (!XmlParser.isValid((Serializer)serializer, SitePageList.class, (String)xml)) {
            log.error((Object)("Invalid SitePageList: " + xml));
            return tools;
        }
        try {
            SitePageList sitePageList = (SitePageList)serializer.read(SitePageList.class, xml);
            List pages = sitePageList.getPageList().getPages();
            for (Page p : pages) {
                tools.addAll(p.getTools());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Num tools found: " + tools.size()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tools;
    }

    private static boolean isValid(Serializer serializer, Class<?> clazz, String xml) {
        if (StringUtils.isBlank((String)xml)) {
            return false;
        }
        try {
            if (serializer.validate(clazz, xml)) {
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to validate xml: " + e.getClass().getName() + ": " + e.getMessage()));
        }
        return false;
    }
}

