/*
 * Decompiled with CFR 0.152.
 */
package au.edu.anu.portal.portlets.sakaiconnector;

import au.edu.anu.portal.portlets.sakaiconnector.helper.SakaiWebServiceHelper;
import au.edu.anu.portal.portlets.sakaiconnector.logic.SakaiWebServiceLogic;
import au.edu.anu.portal.portlets.sakaiconnector.models.Site;
import au.edu.anu.portal.portlets.sakaiconnector.support.CollectionsSupport;
import au.edu.anu.portal.portlets.sakaiconnector.support.HttpSupport;
import au.edu.anu.portal.portlets.sakaiconnector.support.OAuthSupport;
import au.edu.anu.portal.portlets.sakaiconnector.utils.Messages;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletURL;
import javax.portlet.ReadOnlyException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ValidatorException;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PortletDispatcher
extends GenericPortlet {
    private static final Log log = LogFactory.getLog(PortletDispatcher.class);
    private String viewUrl;
    private String editUrl;
    private String proxyUrl;
    private String errorUrl;
    private String configUrl;
    private String key;
    private String secret;
    private String endpoint;
    private String adminUsername;
    private String adminPassword;
    private String loginUrl;
    private String scriptUrl;
    private String allowedTools;
    private String attributeMappingForUsername;
    private boolean replayForm;
    private boolean isValid;
    private Cache cache;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        log.info((Object)"init()");
        this.viewUrl = config.getInitParameter("viewUrl");
        this.editUrl = config.getInitParameter("editUrl");
        this.proxyUrl = config.getInitParameter("proxyUrl");
        this.errorUrl = config.getInitParameter("errorUrl");
        this.configUrl = config.getInitParameter("configUrl");
        this.attributeMappingForUsername = config.getInitParameter("portal.attribute.mapping.username");
        CacheManager.create();
        this.cache = CacheManager.getInstance().getCache("au.edu.anu.portal.portlets.cache.SakaiConnectorPortletCache");
    }

    protected void doDispatch(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        log.debug((Object)"doDispatch()");
        this.getGlobalConfiguration(request);
        if (StringUtils.equalsIgnoreCase((String)request.getPortletMode().toString(), (String)"CONFIG")) {
            this.doConfig(request, response);
        } else {
            super.doDispatch(request, response);
        }
    }

    public void processAction(ActionRequest request, ActionResponse response) {
        log.debug((Object)"processAction()");
        if (StringUtils.equalsIgnoreCase((String)request.getPortletMode().toString(), (String)"CONFIG")) {
            this.processConfigAction(request, response);
        } else if (StringUtils.equalsIgnoreCase((String)request.getPortletMode().toString(), (String)"EDIT")) {
            this.processEditAction(request, response);
        } else {
            log.error((Object)("No handler for PortletMode: " + request.getPortletMode().toString()));
        }
    }

    private void processConfigAction(ActionRequest request, ActionResponse response) {
        log.debug((Object)"processConfigAction()");
        boolean success = true;
        PortletPreferences prefs = request.getPreferences();
        try {
            prefs.setValue("key", request.getParameter("key"));
            prefs.setValue("secret", request.getParameter("secret"));
            prefs.setValue("endpoint", request.getParameter("endpoint"));
            prefs.setValue("adminUsername", request.getParameter("adminUsername"));
            prefs.setValue("adminPassword", request.getParameter("adminPassword"));
            prefs.setValue("loginUrl", request.getParameter("loginUrl"));
            prefs.setValue("scriptUrl", request.getParameter("scriptUrl"));
            prefs.setValue("allowedTools", request.getParameter("allowedTools"));
            prefs.setValue("portletTitle", request.getParameter("portletTitle"));
        }
        catch (ReadOnlyException e) {
            success = false;
            response.setRenderParameter("errorMessage", Messages.getString("error.form.readonly.error"));
            log.error((Object)e);
        }
        if (success) {
            try {
                prefs.store();
                response.setPortletMode(PortletMode.VIEW);
            }
            catch (ValidatorException e) {
                response.setRenderParameter("errorMessage", e.getMessage());
                log.error((Object)e);
            }
            catch (IOException e) {
                response.setRenderParameter("errorMessage", Messages.getString("error.form.save.error"));
                log.error((Object)e);
            }
            catch (PortletModeException e) {
                e.printStackTrace();
            }
        }
    }

    private void processEditAction(ActionRequest request, ActionResponse response) {
        log.debug((Object)"processEditAction()");
        this.replayForm = false;
        this.isValid = false;
        PortletPreferences prefs = request.getPreferences();
        String portletHeight = request.getParameter("portletHeight");
        String portletTitle = StringEscapeUtils.escapeHtml((String)StringUtils.trim((String)request.getParameter("portletTitle")));
        String remoteSiteId = request.getParameter("remoteSiteId");
        String remoteToolId = request.getParameter("remoteToolId");
        if (StringUtils.isBlank((String)remoteSiteId)) {
            this.replayForm = true;
            response.setRenderParameter("portletTitle", portletTitle);
            response.setRenderParameter("portletHeight", portletHeight);
            return;
        }
        if (StringUtils.isBlank((String)remoteToolId)) {
            this.replayForm = true;
            response.setRenderParameter("portletTitle", portletTitle);
            response.setRenderParameter("portletHeight", portletHeight);
            response.setRenderParameter("remoteSiteId", remoteSiteId);
            return;
        }
        try {
            prefs.setValue("portletHeight", portletHeight);
            if (StringUtils.isNotBlank((String)portletTitle)) {
                prefs.setValue("portletTitle", portletTitle);
            }
            prefs.setValue("remoteSiteId", remoteSiteId);
            prefs.setValue("remoteToolId", remoteToolId);
        }
        catch (ReadOnlyException e) {
            this.replayForm = true;
            response.setRenderParameter("errorMessage", Messages.getString("error.form.readonly.error"));
            log.error((Object)e);
            return;
        }
        try {
            prefs.store();
            this.isValid = true;
        }
        catch (ValidatorException e) {
            this.replayForm = true;
            response.setRenderParameter("errorMessage", e.getMessage());
            log.error((Object)e);
            return;
        }
        catch (IOException e) {
            this.replayForm = true;
            response.setRenderParameter("errorMessage", Messages.getString("error.form.save.error"));
            log.error((Object)e);
            return;
        }
        if (this.isValid) {
            try {
                response.setPortletMode(PortletMode.VIEW);
            }
            catch (PortletModeException e) {
                e.printStackTrace();
            }
        }
    }

    protected void doConfig(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        log.debug((Object)"doConfig()");
        request.setAttribute("key", (Object)this.key);
        request.setAttribute("secret", (Object)this.secret);
        request.setAttribute("endpoint", (Object)this.endpoint);
        request.setAttribute("adminUsername", (Object)this.adminUsername);
        request.setAttribute("adminPassword", (Object)this.adminPassword);
        request.setAttribute("loginUrl", (Object)this.loginUrl);
        request.setAttribute("scriptUrl", (Object)this.scriptUrl);
        request.setAttribute("allowedTools", (Object)this.allowedTools);
        request.setAttribute("portletTitle", (Object)this.getTitle(request));
        this.dispatch(request, response, this.configUrl);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        log.debug((Object)"doView()");
        Map<String, String> launchData = this.getLaunchData(request, response);
        if (launchData == null) {
            return;
        }
        StringBuilder proxy = new StringBuilder();
        proxy.append(request.getContextPath());
        proxy.append(this.proxyUrl);
        proxy.append("?");
        proxy.append(HttpSupport.serialiseMapToQueryString(launchData));
        request.setAttribute("proxyContextUrl", (Object)proxy.toString());
        request.setAttribute("preferredHeight", (Object)this.getPreferredPortletHeight(request));
        this.dispatch(request, response, this.viewUrl);
    }

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        log.debug((Object)"doEdit()");
        if (StringUtils.isBlank((String)this.adminUsername) || StringUtils.isBlank((String)this.adminPassword) || StringUtils.isBlank((String)this.loginUrl) || StringUtils.isBlank((String)this.scriptUrl) || StringUtils.isBlank((String)this.allowedTools)) {
            log.error((Object)"Sakai configuration incomplete or missing. Please configure this portlet.");
            this.doError("error.no.sakai.config", "error.heading.general", request, response);
            return;
        }
        SakaiWebServiceLogic logic = new SakaiWebServiceLogic();
        logic.setAdminUsername(this.adminUsername);
        logic.setAdminPassword(this.adminPassword);
        logic.setLoginUrl(this.loginUrl);
        logic.setScriptUrl(this.scriptUrl);
        request.setAttribute("logic", (Object)logic);
        String remoteUserId = this.getRemoteUserId(request, logic);
        if (StringUtils.isBlank((String)remoteUserId)) {
            log.error((Object)"No user info was returned from remote server.");
            this.doError("error.no.remote.data", "error.heading.general", request, response);
            return;
        }
        request.setAttribute("eid", (Object)this.getAuthenticatedUsername(request));
        request.setAttribute("remoteUserId", (Object)remoteUserId);
        List<Site> sites = this.getRemoteSitesForUser(request, logic);
        if (sites.isEmpty()) {
            log.error((Object)"No sites were returned from remote server.");
            this.doError("error.no.remote.data", "error.heading.general", request, response);
            return;
        }
        request.setAttribute("remoteSites", sites);
        request.setAttribute("allowedToolIds", Arrays.asList(StringUtils.split((String)this.allowedTools, (char)':')));
        if (this.replayForm) {
            String preferredRemoteSiteId;
            String portletTitle = request.getParameter("portletTitle");
            String portletHeight = request.getParameter("portletHeight");
            String remoteSiteId = request.getParameter("remoteSiteId");
            String remoteToolId = request.getParameter("remoteToolId");
            if (StringUtils.isBlank((String)portletTitle)) {
                portletTitle = this.getPreferredPortletTitle(request);
            }
            if (StringUtils.isBlank((String)portletHeight)) {
                portletHeight = String.valueOf(this.getPreferredPortletHeight(request));
            }
            if (StringUtils.isBlank((String)remoteSiteId)) {
                remoteSiteId = this.getPreferredRemoteSiteId(request);
            }
            if (StringUtils.isBlank((String)remoteToolId) && StringUtils.equals((String)remoteSiteId, (String)(preferredRemoteSiteId = this.getPreferredRemoteSiteId(request)))) {
                remoteToolId = this.getPreferredRemoteToolId(request);
            }
            request.setAttribute("preferredPortletHeight", (Object)portletHeight);
            request.setAttribute("preferredPortletTitle", (Object)portletTitle);
            request.setAttribute("preferredRemoteSiteId", (Object)remoteSiteId);
            request.setAttribute("preferredRemoteToolId", (Object)remoteToolId);
            request.setAttribute("errorMessage", (Object)request.getParameter("errorMessage"));
        } else {
            request.setAttribute("preferredPortletHeight", (Object)this.getPreferredPortletHeight(request));
            request.setAttribute("preferredPortletTitle", (Object)this.getPreferredPortletTitle(request));
            request.setAttribute("preferredRemoteSiteId", (Object)this.getPreferredRemoteSiteId(request));
            request.setAttribute("preferredRemoteToolId", (Object)this.getPreferredRemoteToolId(request));
            this.evictFromCache(this.getPortletNamespace(response));
        }
        request.setAttribute("cancelUrl", (Object)this.getPortletModeUrl(response, PortletMode.VIEW));
        this.dispatch(request, response, this.editUrl);
    }

    private Map<String, String> getUserInfo(RenderRequest request) {
        return (Map)request.getAttribute("javax.portlet.userinfo");
    }

    private String getPortletNamespace(RenderResponse response) {
        return response.getNamespace();
    }

    private Map<String, String> getLaunchData(RenderRequest request, RenderResponse response) {
        if (StringUtils.isBlank((String)this.key) || StringUtils.isBlank((String)this.secret) || StringUtils.isBlank((String)this.endpoint) || StringUtils.isBlank((String)this.scriptUrl)) {
            log.error((Object)"Basic LTI configuration incomplete or missing. Please configure this portlet.");
            this.doError("error.no.basiclti.config", "error.heading.general", request, response);
            return null;
        }
        if (StringUtils.isBlank((String)this.adminUsername) || StringUtils.isBlank((String)this.adminPassword) || StringUtils.isBlank((String)this.loginUrl) || StringUtils.isBlank((String)this.scriptUrl)) {
            log.error((Object)"Sakai configuration incomplete or missing. Please configure this portlet.");
            this.doError("error.no.sakai.config", "error.heading.general", request, response);
            return null;
        }
        String cacheKey = this.getPortletNamespace(response);
        Map<String, String> params = this.retrieveFromCache(cacheKey);
        if (params == null) {
            params = new HashMap<String, String>();
            String preferredRemoteSiteId = this.getPreferredRemoteSiteId(request);
            if (StringUtils.isBlank((String)preferredRemoteSiteId)) {
                this.doError("error.no.config", "error.heading.config", this.getPortletModeUrl(response, PortletMode.EDIT), request, response);
                return null;
            }
            String preferredRemoteToolId = this.getPreferredRemoteToolId(request);
            if (StringUtils.isBlank((String)preferredRemoteToolId)) {
                this.doError("error.no.config", "error.heading.config", this.getPortletModeUrl(response, PortletMode.EDIT), request, response);
                return null;
            }
            SakaiWebServiceLogic logic = new SakaiWebServiceLogic();
            logic.setAdminUsername(this.adminUsername);
            logic.setAdminPassword(this.adminPassword);
            logic.setLoginUrl(this.loginUrl);
            logic.setScriptUrl(this.scriptUrl);
            String remoteUserId = this.getRemoteUserId(request, logic);
            if (StringUtils.isBlank((String)remoteUserId)) {
                this.doError("error.no.remote.data", "error.heading.general", request, response);
                return null;
            }
            params.put("endpoint_url", this.endpoint + preferredRemoteToolId);
            params.put("user_id", this.getAuthenticatedUsername(request));
            params.put("lis_person_name_given", null);
            params.put("lis_person_name_family", null);
            params.put("lis_person_name_full", null);
            params.put("lis_person_contact_email_primary", null);
            params.put("resource_link_id", this.getPortletNamespace(response));
            params.put("context_id", preferredRemoteSiteId);
            params.put("tool_consumer_instance_guid", this.key);
            params.put("lti_version", "LTI-1p0");
            params.put("lti_message_type", "basic-lti-launch-request");
            params.put("oauth_callback", "about:blank");
            params.put("basiclti_submit", "Launch Endpoint with BasicLTI Data");
            params.put("user_id", remoteUserId);
            params.put("remote_tool_id", preferredRemoteToolId);
            this.updateCache(cacheKey, params);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Parameter map before OAuth signing");
            CollectionsSupport.printMap(params);
        }
        params = OAuthSupport.signProperties(params.get("endpoint_url"), params, "POST", this.key, this.secret);
        if (log.isDebugEnabled()) {
            log.warn((Object)"Parameter map after OAuth signing");
            CollectionsSupport.printMap(params);
        }
        return params;
    }

    private int getPreferredPortletHeight(RenderRequest request) {
        PortletPreferences pref = request.getPreferences();
        return Integer.parseInt(pref.getValue("portletHeight", String.valueOf(600)));
    }

    private String getPreferredPortletTitle(RenderRequest request) {
        PortletPreferences pref = request.getPreferences();
        return pref.getValue("portletTitle", "Sakai-uPortal connector");
    }

    private String getPreferredRemoteSiteId(RenderRequest request) {
        PortletPreferences pref = request.getPreferences();
        return pref.getValue("remoteSiteId", null);
    }

    private String getPreferredRemoteToolId(RenderRequest request) {
        PortletPreferences pref = request.getPreferences();
        return pref.getValue("remoteToolId", null);
    }

    private String getAuthenticatedUsername(RenderRequest request) {
        Map<String, String> userInfo = this.getUserInfo(request);
        return userInfo.get(this.attributeMappingForUsername);
    }

    private String getRemoteUserId(RenderRequest request, SakaiWebServiceLogic logic) {
        String remoteUserId = (String)request.getPortletSession().getAttribute("remoteUserId");
        if (StringUtils.isBlank((String)remoteUserId)) {
            remoteUserId = SakaiWebServiceHelper.getRemoteUserIdForUser(logic, this.getAuthenticatedUsername(request));
            request.getPortletSession().setAttribute("remoteUserId", (Object)remoteUserId);
        }
        return remoteUserId;
    }

    private List<Site> getRemoteSitesForUser(RenderRequest request, SakaiWebServiceLogic logic) {
        return SakaiWebServiceHelper.getAllSitesForUser(logic, this.getAuthenticatedUsername(request));
    }

    protected String getTitle(RenderRequest request) {
        return this.getPreferredPortletTitle(request);
    }

    private void getGlobalConfiguration(RenderRequest request) {
        PortletPreferences pref = request.getPreferences();
        this.key = pref.getValue("key", null);
        this.secret = pref.getValue("secret", null);
        this.endpoint = pref.getValue("endpoint", null);
        this.adminUsername = pref.getValue("adminUsername", null);
        this.adminPassword = pref.getValue("adminPassword", null);
        this.loginUrl = pref.getValue("loginUrl", null);
        this.scriptUrl = pref.getValue("scriptUrl", null);
        this.allowedTools = pref.getValue("allowedTools", null);
    }

    private void doError(String messageKey, String headingKey, RenderRequest request, RenderResponse response) {
        this.doError(messageKey, headingKey, null, request, response);
    }

    private void doError(String messageKey, String headingKey, String link, RenderRequest request, RenderResponse response) {
        request.setAttribute("errorMessage", (Object)Messages.getString(messageKey));
        if (StringUtils.isNotBlank((String)headingKey)) {
            request.setAttribute("errorHeading", (Object)Messages.getString(headingKey));
        } else {
            request.setAttribute("errorHeading", (Object)Messages.getString("error.heading.general"));
        }
        if (StringUtils.isNotBlank((String)link)) {
            request.setAttribute("errorLink", (Object)link);
        }
        try {
            this.dispatch(request, response, this.errorUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void dispatch(RenderRequest request, RenderResponse response, String path) throws PortletException, IOException {
        response.setContentType("text/html");
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher(path);
        dispatcher.include(request, response);
    }

    private void evictFromCache(String cacheKey) {
        this.cache.remove((Serializable)((Object)cacheKey));
        log.debug((Object)("Evicted data in cache for key: " + cacheKey));
    }

    private Map<String, String> retrieveFromCache(String key) {
        Element element = this.cache.get((Serializable)((Object)key));
        if (element != null) {
            Map data = (Map)element.getObjectValue();
            log.debug((Object)("Fetching data from cache for key: " + key));
            return data;
        }
        return null;
    }

    private void updateCache(String cacheKey, Map<String, String> data) {
        this.cache.put(new Element((Object)cacheKey, data));
        log.debug((Object)("Added data to cache for key: " + cacheKey));
    }

    private String getPortletModeUrl(RenderResponse response, PortletMode mode) {
        PortletURL url = response.createRenderURL();
        try {
            url.setPortletMode(mode);
        }
        catch (PortletModeException e) {
            log.error((Object)("Invalid portlet mode: " + mode));
            return null;
        }
        return url.toString();
    }

    public void destroy() {
        log.info((Object)"destroy()");
        CacheManager.getInstance().shutdown();
    }
}

