/*
 * Decompiled with CFR 0.152.
 */
package au.edu.anu.portal.portlets.sakaiconnector.logic;

import au.edu.anu.portal.portlets.sakaiconnector.models.Site;
import au.edu.anu.portal.portlets.sakaiconnector.models.Tool;
import au.edu.anu.portal.portlets.sakaiconnector.support.WebServiceSupport;
import au.edu.anu.portal.portlets.sakaiconnector.utils.XmlParser;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SakaiWebServiceLogic {
    private static final Log log = LogFactory.getLog(SakaiWebServiceLogic.class);
    private String adminUsername;
    private String adminPassword;
    private String loginUrl;
    private String scriptUrl;
    private static final String METHOD_LOGIN = "login";
    private static final String METHOD_GET_USER_ID = "getUserId";
    private static final String METHOD_CHECK_SESSION = "checkSession";
    private static final String METHOD_GET_ALL_SITES_FOR_USER = "getAllSitesForUser";
    private static final String METHOD_GET_PAGES_AND_TOOLS_FOR_SITE = "getPagesAndToolsForSite";
    private Cache cache;
    private static final String CACHE_KEY = "admin_remote_session_id";

    public String getRemoteUserIdForUser(final String eid) {
        HashMap<String, Map<String, String>> data = new HashMap<String, Map<String, String>>();
        data.put("sessionid", new HashMap<String, String>(){
            {
                this.put("value", SakaiWebServiceLogic.this.getSession());
                this.put("type", "string");
            }
        });
        data.put("eid", new HashMap<String, String>(){
            {
                this.put("value", eid);
                this.put("type", "string");
            }
        });
        return WebServiceSupport.call(this.getScriptUrl(), METHOD_GET_USER_ID, data);
    }

    public List<Site> getAllSitesForUser(final String eid) {
        HashMap<String, Map<String, String>> data = new HashMap<String, Map<String, String>>();
        data.put("sessionid", new HashMap<String, String>(){
            {
                this.put("value", SakaiWebServiceLogic.this.getSession());
                this.put("type", "string");
            }
        });
        data.put("eid", new HashMap<String, String>(){
            {
                this.put("value", eid);
                this.put("type", "string");
            }
        });
        String xml = WebServiceSupport.call(this.getScriptUrl(), METHOD_GET_ALL_SITES_FOR_USER, data);
        return XmlParser.parseListOfSites(xml);
    }

    public List<Tool> getToolsForSite(final String siteId, final String eid) {
        HashMap<String, Map<String, String>> data = new HashMap<String, Map<String, String>>();
        data.put("sessionid", new HashMap<String, String>(){
            {
                this.put("value", SakaiWebServiceLogic.this.getSession());
                this.put("type", "string");
            }
        });
        data.put("userid", new HashMap<String, String>(){
            {
                this.put("value", eid);
                this.put("type", "string");
            }
        });
        data.put("siteid", new HashMap<String, String>(){
            {
                this.put("value", siteId);
                this.put("type", "string");
            }
        });
        String xml = WebServiceSupport.call(this.getScriptUrl(), METHOD_GET_PAGES_AND_TOOLS_FOR_SITE, data);
        return XmlParser.parseListOfPages(xml);
    }

    private String getNewAdminSession() {
        String session = null;
        HashMap<String, Map<String, String>> data = new HashMap<String, Map<String, String>>();
        data.put("id", new HashMap<String, String>(){
            {
                this.put("value", SakaiWebServiceLogic.this.getAdminUsername());
                this.put("type", "string");
            }
        });
        data.put("pw", new HashMap<String, String>(){
            {
                this.put("value", SakaiWebServiceLogic.this.getAdminPassword());
                this.put("type", "string");
            }
        });
        session = WebServiceSupport.call(this.getLoginUrl(), METHOD_LOGIN, data);
        this.addSessionToCache(session);
        return session;
    }

    private boolean isSessionActive(final String session) {
        HashMap<String, Map<String, String>> data = new HashMap<String, Map<String, String>>();
        data.put("sessionid", new HashMap<String, String>(){
            {
                this.put("value", session);
                this.put("type", "string");
            }
        });
        String results = WebServiceSupport.call(this.getScriptUrl(), METHOD_CHECK_SESSION, data);
        return StringUtils.equals((String)results, (String)session);
    }

    public SakaiWebServiceLogic() {
        CacheManager.create();
        this.cache = CacheManager.getInstance().getCache("au.edu.anu.portal.portlets.cache.SakaiConnectorPortletCache");
    }

    private String getSession() {
        String session = this.getSessionFromCache();
        if (StringUtils.isBlank((String)session)) {
            return this.getNewAdminSession();
        }
        if (!this.isSessionActive(session)) {
            this.getNewAdminSession();
        }
        return session;
    }

    private String getSessionFromCache() {
        Element element = this.cache.get((Serializable)((Object)CACHE_KEY));
        if (element != null) {
            String session = (String)element.getObjectValue();
            log.debug((Object)("Fetching session from cache: " + session));
            return session;
        }
        return null;
    }

    private void addSessionToCache(String session) {
        this.cache.put(new Element((Serializable)((Object)CACHE_KEY), (Serializable)((Object)session)));
        log.debug((Object)("Adding session to cache: " + session));
    }

    public String getAdminUsername() {
        return this.adminUsername;
    }

    public void setAdminUsername(String adminUsername) {
        this.adminUsername = adminUsername;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public String getScriptUrl() {
        return this.scriptUrl;
    }

    public void setScriptUrl(String scriptUrl) {
        this.scriptUrl = scriptUrl;
    }
}

