/*
 * Decompiled with CFR 0.152.
 */
package au.edu.anu.portal.portlets.rss;

import au.edu.anu.portal.portlets.rss.FeedParser;
import au.edu.anu.portal.portlets.rss.model.Attachment;
import au.edu.anu.portal.portlets.rss.utils.Messages;
import com.sun.syndication.feed.synd.SyndFeed;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletURL;
import javax.portlet.ReadOnlyException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ValidatorException;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleRSSPortlet
extends GenericPortlet {
    private static final Log log = LogFactory.getLog(SimpleRSSPortlet.class);
    private String viewUrl;
    private String editUrl;
    private String errorUrl;
    private String noContentUrl;
    private CacheManager cacheManager;
    private Cache feedCache;
    private Cache mediaCache;
    private static final String FEED_CACHE_NAME = "au.edu.anu.portal.portlets.cache.SimpleRSSPortletCache.feed";
    private static final String MEDIA_CACHE_NAME = "au.edu.anu.portal.portlets.cache.SimpleRSSPortletCache.media";
    private final String PREF_PORTLET_TITLE = "portlet_title";
    private final String PREF_FEED_URL = "feed_url";
    private final String PREF_MAX_ITEMS = "max_items";

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        log.info((Object)"Simple RSS Portlet init()");
        this.viewUrl = config.getInitParameter("viewUrl");
        this.editUrl = config.getInitParameter("editUrl");
        this.errorUrl = config.getInitParameter("errorUrl");
        this.noContentUrl = config.getInitParameter("noContentUrl");
        this.cacheManager = new CacheManager();
        this.feedCache = this.cacheManager.getCache(FEED_CACHE_NAME);
        this.mediaCache = this.cacheManager.getCache(MEDIA_CACHE_NAME);
    }

    protected void doDispatch(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        log.debug((Object)"Simple RSS doDispatch()");
        if (StringUtils.equalsIgnoreCase((String)request.getPortletMode().toString(), (String)"CONFIG")) {
            this.doConfig(request, response);
        } else {
            super.doDispatch(request, response);
        }
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        log.debug((Object)"Simple RSS doView()");
        String feedUrl = this.getConfiguredFeedUrl(request);
        SyndFeed feed = this.getFeedContent(request, response);
        if (feed == null) {
            return;
        }
        if (feed.getEntries().isEmpty()) {
            this.dispatch(request, response, this.noContentUrl);
        }
        Map<String, Attachment> media = this.getFeedMedia(feed, feedUrl);
        int maxItems = this.getConfiguredMaxItems(request) - 1;
        request.setAttribute("SyndFeed", (Object)feed);
        request.setAttribute("Media", media);
        request.setAttribute("maxItems", (Object)maxItems);
        this.dispatch(request, response, this.viewUrl);
    }

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        log.debug((Object)"Simple RSS doEdit()");
        String errorMessage = request.getParameter("errorMessage");
        if (StringUtils.isNotBlank((String)errorMessage)) {
            request.setAttribute("portletTitle", (Object)request.getParameter("portletTitle"));
            request.setAttribute("feedUrl", (Object)request.getParameter("feedUrl"));
            request.setAttribute("maxItems", (Object)request.getParameter("maxItems"));
        } else {
            request.setAttribute("portletTitle", (Object)this.getConfiguredPortletTitle(request));
            request.setAttribute("feedUrl", (Object)this.getConfiguredFeedUrl(request));
            request.setAttribute("maxItems", (Object)this.getConfiguredMaxItems(request));
        }
        request.setAttribute("feedUrlIsLocked", (Object)this.isPrefLocked((PortletRequest)request, "feed_url"));
        request.setAttribute("portletTitleIsLocked", (Object)this.isPrefLocked((PortletRequest)request, "portlet_title"));
        request.setAttribute("cancelUrl", (Object)this.getPortletModeUrl(response, PortletMode.VIEW));
        request.setAttribute("errorMessage", (Object)request.getParameter("errorMessage"));
        this.dispatch(request, response, this.editUrl);
    }

    protected void doConfig(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        log.debug((Object)"Simple RSS doConfig()");
        this.doEdit(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletModeException {
        log.debug((Object)"Simple RSS processAction()");
        boolean success = true;
        PortletPreferences prefs = request.getPreferences();
        String portletTitle = StringEscapeUtils.escapeHtml((String)StringUtils.trim((String)request.getParameter("portletTitle")));
        String maxItems = StringUtils.trim((String)request.getParameter("maxItems"));
        String feedUrl = StringUtils.trim((String)request.getParameter("feedUrl"));
        if (StringUtils.isBlank((String)portletTitle)) {
            portletTitle = "My RSS Feed";
        }
        boolean feedUrlIsLocked = this.isPrefLocked((PortletRequest)request, "feed_url");
        boolean portletTitleIsLocked = this.isPrefLocked((PortletRequest)request, "portlet_title");
        try {
            if (!portletTitleIsLocked) {
                prefs.setValue("portlet_title", portletTitle);
            }
            if (!feedUrlIsLocked) {
                prefs.setValue("feed_url", feedUrl);
            }
            prefs.setValue("max_items", maxItems);
        }
        catch (ReadOnlyException e) {
            success = false;
            response.setRenderParameter("errorMessage", Messages.getString("error.form.readonly.error"));
            log.error((Object)e);
        }
        if (success) {
            try {
                prefs.store();
                response.setPortletMode(PortletMode.VIEW);
            }
            catch (ValidatorException e) {
                response.setRenderParameter("errorMessage", e.getMessage());
                response.setRenderParameter("portletTitle", portletTitle);
                response.setRenderParameter("maxItems", maxItems);
                if (!feedUrlIsLocked) {
                    response.setRenderParameter("feedUrl", feedUrl);
                }
                log.error((Object)e);
            }
            catch (IOException e) {
                response.setRenderParameter("errorMessage", Messages.getString("error.form.save.error"));
                log.error((Object)e);
            }
            catch (PortletModeException e) {
                e.printStackTrace();
            }
        }
    }

    private SyndFeed getFeedContent(RenderRequest request, RenderResponse response) {
        SyndFeed feed;
        String feedUrl = this.getConfiguredFeedUrl(request);
        if (StringUtils.isBlank((String)feedUrl)) {
            log.debug((Object)"No feed URL configured");
            this.doError("error.no.config", "error.heading.config", this.getPortletModeUrl(response, PortletMode.EDIT), request, response);
            return null;
        }
        String cacheKey = feedUrl;
        Element element = this.feedCache.get((Serializable)((Object)cacheKey));
        if (element != null) {
            log.debug((Object)("Fetching data from feed cache for: " + cacheKey));
            feed = (SyndFeed)element.getObjectValue();
            if (feed == null) {
                log.warn((Object)"Feed cache data invalid, attempting a refresh...");
                feed = this.getRemoteFeed(feedUrl, request, response);
            }
        } else {
            feed = this.getRemoteFeed(feedUrl, request, response);
        }
        return feed;
    }

    private SyndFeed getRemoteFeed(String feedUrl, RenderRequest request, RenderResponse response) {
        SyndFeed feed = new FeedParser().parseFeed(feedUrl);
        if (feed == null) {
            log.error((Object)"No data was returned from remote server.");
            this.doError("error.no.remote.data", "error.heading.general", request, response);
            return null;
        }
        log.debug((Object)("Adding data to feed cache for: " + feedUrl));
        this.feedCache.put(new Element((Object)feedUrl, (Object)feed));
        return feed;
    }

    private Map<String, Attachment> getFeedMedia(SyndFeed feed, String feedUrl) {
        Element element = this.mediaCache.get((Serializable)((Object)feedUrl));
        if (element != null) {
            log.debug((Object)("Fetching data from media cache for: " + feedUrl));
            return (Map)element.getObjectValue();
        }
        Map<String, Attachment> media = FeedParser.parseFeedEnclosures(feed);
        log.debug((Object)("Adding data to media cache for: " + feedUrl));
        this.mediaCache.put(new Element((Object)feedUrl, media));
        return media;
    }

    private String getConfiguredPortletTitle(RenderRequest request) {
        PortletPreferences pref = request.getPreferences();
        return pref.getValue("portlet_title", "My RSS Feed");
    }

    private String getConfiguredFeedUrl(RenderRequest request) {
        PortletPreferences pref = request.getPreferences();
        return pref.getValue("feed_url", null);
    }

    private int getConfiguredMaxItems(RenderRequest request) {
        PortletPreferences pref = request.getPreferences();
        return Integer.valueOf(pref.getValue("max_items", Integer.toString(5)));
    }

    protected String getTitle(RenderRequest request) {
        return this.getConfiguredPortletTitle(request);
    }

    private void doError(String messageKey, String headingKey, RenderRequest request, RenderResponse response) {
        this.doError(messageKey, headingKey, null, request, response);
    }

    private void doError(String messageKey, String headingKey, String link, RenderRequest request, RenderResponse response) {
        request.setAttribute("errorMessage", (Object)Messages.getString(messageKey));
        if (StringUtils.isNotBlank((String)headingKey)) {
            request.setAttribute("errorHeading", (Object)Messages.getString(headingKey));
        } else {
            request.setAttribute("errorHeading", (Object)Messages.getString("error.heading.general"));
        }
        if (StringUtils.isNotBlank((String)link)) {
            request.setAttribute("errorLink", (Object)link);
        }
        try {
            this.dispatch(request, response, this.errorUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void dispatch(RenderRequest request, RenderResponse response, String path) throws PortletException, IOException {
        response.setContentType("text/html");
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher(path);
        dispatcher.include(request, response);
    }

    private String getPortletModeUrl(RenderResponse response, PortletMode mode) {
        PortletURL url = response.createRenderURL();
        try {
            url.setPortletMode(mode);
        }
        catch (PortletModeException e) {
            log.error((Object)("Invalid portlet mode: " + mode));
            return null;
        }
        return url.toString();
    }

    private boolean isPrefLocked(PortletRequest request, String prefName) {
        PortletPreferences prefs = request.getPreferences();
        try {
            return prefs.isReadOnly(prefName);
        }
        catch (IllegalArgumentException e) {
            log.debug((Object)("Preference does not exist: " + prefName));
            return false;
        }
    }

    public void destroy() {
        log.info((Object)"Simple RSS Portlet destroy()");
        this.cacheManager.shutdown();
    }
}

