/*
 * Decompiled with CFR 0.152.
 */
package au.edu.anu.portal.portlets.rss;

import au.edu.anu.portal.portlets.rss.model.Attachment;
import au.edu.anu.portal.portlets.rss.utils.Messages;
import com.sun.syndication.feed.synd.SyndEnclosure;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class FeedParser {
    private SyndFeedInput input = new SyndFeedInput();

    public SyndFeed parseFeed(String feedUrl) {
        try {
            URL url = new URL(feedUrl);
            XmlReader reader = new XmlReader(url);
            SyndFeed feed = this.input.build((Reader)reader);
            return feed;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (FeedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Map<String, Attachment> parseFeedEnclosures(SyndFeed feed) {
        HashMap<String, Attachment> attachments = new HashMap<String, Attachment>();
        ArrayList<String> imageTypes = new ArrayList<String>();
        imageTypes.add("image/jpeg");
        imageTypes.add("image/gif");
        imageTypes.add("image/png");
        imageTypes.add("image/jpg");
        List entries = feed.getEntries();
        for (SyndEntry entry : entries) {
            if (StringUtils.isBlank((String)entry.getUri())) continue;
            List enclosures = entry.getEnclosures();
            for (SyndEnclosure e : enclosures) {
                Attachment a = new Attachment();
                a.setUrl(e.getUrl());
                a.setDisplayLength(FeedParser.formatLength(e.getLength()));
                a.setType(e.getType());
                String displayName = StringUtils.substringAfterLast((String)e.getUrl(), (String)"/");
                if (StringUtils.isNotBlank((String)displayName)) {
                    a.setDisplayName(displayName);
                } else {
                    a.setDisplayName(Messages.getString("view.attachment.default"));
                }
                if (imageTypes.contains(e.getType())) {
                    a.setImage(true);
                }
                attachments.put(entry.getUri(), a);
            }
        }
        return attachments;
    }

    private static String formatLength(long length) {
        return FileUtils.byteCountToDisplaySize((long)length);
    }
}

