/*
 * Decompiled with CFR 0.152.
 */
package au.edu.anu.portal.portlets.rss.validator;

import au.edu.anu.portal.portlets.rss.validator.DetailedUrlValidator;
import java.util.Arrays;
import java.util.Collections;
import javax.portlet.PortletPreferences;
import javax.portlet.PreferencesValidator;
import javax.portlet.ValidatorException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.IntegerValidator;

public class SimpleRSSPreferencesValidator
implements PreferencesValidator {
    public void validate(PortletPreferences prefs) throws ValidatorException {
        String max_items = prefs.getValue("max_items", Integer.toString(5));
        String feed_url = prefs.getValue("feed_url", null);
        boolean feedUrlIsLocked = prefs.isReadOnly("feed_url");
        IntegerValidator integerValidator = IntegerValidator.getInstance();
        Integer maxItems = integerValidator.validate(max_items);
        if (maxItems == null) {
            throw new ValidatorException("Invalid value, must be a number", Collections.singleton("max_items"));
        }
        if (!integerValidator.minValue(maxItems, 1)) {
            throw new ValidatorException("Invalid number, must be greater than 0", Collections.singleton("max_items"));
        }
        if (!feedUrlIsLocked) {
            Object[] schemes = new String[]{"http", "https"};
            DetailedUrlValidator urlValidator = new DetailedUrlValidator((String[])schemes);
            if (StringUtils.isBlank((String)feed_url)) {
                throw new ValidatorException("You must specify a URL for the RSS feed", Collections.singleton("feed_url"));
            }
            if (!urlValidator.isValidScheme(feed_url)) {
                throw new ValidatorException("Invalid feed scheme. Must be one of: " + Arrays.toString(schemes), Collections.singleton("feed_url"));
            }
            if (!urlValidator.isValid(feed_url)) {
                throw new ValidatorException("Invalid feed URL", Collections.singleton("feed_url"));
            }
        }
    }
}

