/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.cms.service;

import java.io.InputStream;
import javax.annotation.Resource;
import org.jasig.portlet.cms.mvc.exception.StringCleaningException;
import org.jasig.portlet.cms.service.IStringCleaningService;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Component;

@Component
public class AntiSamyStringCleaningService
implements IStringCleaningService,
InitializingBean {
    private Policy policy;
    private org.springframework.core.io.Resource resource;

    @Resource(name="policyFile")
    @Required
    public void setResource(org.springframework.core.io.Resource resource) {
        this.resource = resource;
    }

    public void afterPropertiesSet() throws Exception {
        InputStream stream = this.resource.getInputStream();
        this.policy = Policy.getInstance((InputStream)stream);
    }

    public String getSafeContent(String content) {
        try {
            AntiSamy as = this.getAntiSamyInstance();
            CleanResults cr = as.scan(content, this.policy);
            return cr.getCleanHTML();
        }
        catch (ScanException e) {
            throw new StringCleaningException("Failed to scan new content", (Throwable)e);
        }
        catch (PolicyException e) {
            throw new StringCleaningException("Exception while cleaning content", (Throwable)e);
        }
    }

    protected AntiSamy getAntiSamyInstance() {
        return new AntiSamy();
    }
}

