/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.cms.service.dao;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.cms.mvc.exception.ContentPersistenceException;
import org.jasig.portlet.cms.service.dao.IContentDao;
import org.springframework.stereotype.Component;

@Component
public class PortletPreferencesContentDaoImpl
implements IContentDao {
    protected static final String CONTENT_KEY = "content";
    protected final Log log = LogFactory.getLog(this.getClass());

    public String getContent(PortletRequest request, String localeKey) {
        PortletPreferences preferences = request.getPreferences();
        String content = null;
        if (StringUtils.isNotBlank((String)localeKey)) {
            content = preferences.getValue(this.getLocaleSpecificKey(localeKey), null);
        }
        if (content == null) {
            content = preferences.getValue(CONTENT_KEY, "");
        }
        return content;
    }

    public void saveContent(ActionRequest request, String content, String localeKey) {
        try {
            PortletPreferences preferences = request.getPreferences();
            if (StringUtils.isNotBlank((String)localeKey)) {
                preferences.setValue(this.getLocaleSpecificKey(localeKey), content);
            } else {
                preferences.setValue(CONTENT_KEY, content);
            }
            preferences.store();
        }
        catch (ReadOnlyException e) {
            throw new ContentPersistenceException("Failed to save read-only preference", e);
        }
        catch (ValidatorException e) {
            throw new ContentPersistenceException("Portlet preferences validation error while attempting to persist portlet content", e);
        }
        catch (IOException e) {
            throw new ContentPersistenceException("IO error while attempting to persist portlet content", e);
        }
    }

    protected String getLocaleSpecificKey(String localeKey) {
        return CONTENT_KEY.concat("-").concat(localeKey);
    }
}

