/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.cms.mvc.portlet;

import java.util.HashMap;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.cms.mvc.form.ContentForm;
import org.jasig.portlet.cms.service.IStringCleaningService;
import org.jasig.portlet.cms.service.dao.IContentDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;
import org.springframework.web.servlet.ModelAndView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
@RequestMapping(value={"CONFIG"})
public class ConfigureContentController {
    protected final Log log = LogFactory.getLog(this.getClass());
    private IContentDao contentDao;
    private IStringCleaningService cleaningService;

    @Autowired
    public void setContentDao(IContentDao contentDao) {
        this.contentDao = contentDao;
    }

    @Autowired
    public void setStringCleaningService(IStringCleaningService cleaningService) {
        this.cleaningService = cleaningService;
    }

    @RequestMapping
    public String showContentForm() {
        return "configureContent";
    }

    @RequestMapping(params={"action=updateConfiguration"})
    public void updateConfiguration(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") ContentForm form) throws PortletModeException {
        String content = form.getContent();
        String locale = form.getLocale();
        PortletPreferences preferences = request.getPreferences();
        if (Boolean.valueOf(preferences.getValue("cleanContent", "true")).booleanValue()) {
            content = this.cleaningService.getSafeContent(form.getContent());
        }
        this.contentDao.saveContent(request, content, locale);
        response.setPortletMode(PortletMode.VIEW);
    }

    @RequestMapping(params={"action=cancelUpdate"})
    public void cancelUpdate(ActionRequest request, ActionResponse response) throws PortletModeException {
        response.setPortletMode(PortletMode.VIEW);
    }

    @ResourceMapping(value="preview")
    public ModelAndView getPreview(@RequestParam(value="content") String content) {
        HashMap<String, String> model = new HashMap<String, String>();
        String cleanContent = this.cleaningService.getSafeContent(content);
        model.put("content", cleanContent);
        return new ModelAndView("jsonView", model);
    }

    @ModelAttribute(value="form")
    public ContentForm getForm(PortletRequest request) {
        String content = this.contentDao.getContent(request, null);
        ContentForm form = new ContentForm();
        form.setContent(content);
        return form;
    }

    @ModelAttribute(value="cleanContent")
    public boolean isCleanContent(PortletRequest request) {
        PortletPreferences preferences = request.getPreferences();
        return Boolean.valueOf(preferences.getValue("cleanContent", "true"));
    }

    public HashMap<String, String> getLocales(PortletRequest request) {
        PortletPreferences preferences = request.getPreferences();
        String[] supportedLocales = preferences.getValues("supportedLocales", new String[0]);
        HashMap<String, String> locales = new HashMap<String, String>();
        for (String localeString : supportedLocales) {
            localeString = localeString.trim();
            Locale locale = StringUtils.parseLocaleString((String)localeString.trim());
            locales.put(localeString.trim(), localeString.trim() + ": " + locale.getDisplayName());
        }
        return locales;
    }
}

