/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.attachment.filter;

import java.io.File;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.attachment.model.Attachment;
import org.jasig.portlet.attachment.service.IAttachmentService;
import org.jasig.portlet.attachment.util.DataUtil;
import org.jasig.portlet.attachment.util.FileUtil;
import org.springframework.beans.factory.annotation.Autowired;

public final class LocalAttachmentFilter
implements Filter {
    private final Log log = LogFactory.getLog(this.getClass());
    @Autowired
    private IAttachmentService attachmentService = null;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String relative = httpServletRequest.getServletPath();
        String path = httpServletRequest.getSession().getServletContext().getRealPath(relative);
        File file = new File(path);
        if (!file.exists()) {
            int guidIndex;
            String[] parts = path.split("/");
            String guid = parts[guidIndex = parts.length - 2];
            Attachment attachment = this.attachmentService.get(guid, httpServletRequest);
            if (attachment != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Restoring the following  attachment to the server file system:  " + path));
                }
                byte[] content = DataUtil.decode((String)attachment.getData());
                FileUtil.write((String)path, (byte[])content);
            } else if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Attachment not found:  " + path));
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

