/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.attachment.service.impl;

import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.attachment.dao.IAttachmentDao;
import org.jasig.portlet.attachment.model.Attachment;
import org.jasig.portlet.attachment.service.IAttachmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AttachmentService
implements IAttachmentService {
    @Autowired
    private IAttachmentDao attachmentDao;

    public Attachment get(long attachmentId, HttpServletRequest request) {
        return this.attachmentDao.get(attachmentId);
    }

    public Attachment get(String guid, HttpServletRequest request) {
        return this.attachmentDao.get(guid);
    }

    public List<Attachment> find(String creator, HttpServletRequest request) {
        return this.attachmentDao.find(creator);
    }

    public List<Attachment> find(String creator, String filename, HttpServletRequest request) {
        return this.attachmentDao.find(creator, filename);
    }

    public Attachment save(Attachment attachment, HttpServletRequest request) {
        String user;
        Attachment existing = this.attachmentDao.get(attachment.getGuid());
        if (existing != null) {
            existing.setFilename(attachment.getFilename());
            existing.setPath(attachment.getPath());
            existing.setData(attachment.getData());
            attachment = existing;
        }
        if (StringUtils.isBlank((String)(user = request.getRemoteUser()))) {
            throw new IllegalArgumentException("Value for username cannot be blank;  is Tomcat's session path configured for shared sessions?");
        }
        this.updateTimestamps(attachment, user);
        Attachment saved = this.attachmentDao.save(attachment);
        return saved;
    }

    public void delete(Attachment attachment, HttpServletRequest request) {
        this.attachmentDao.delete(attachment);
    }

    public void delete(long attachmentId, HttpServletRequest request) {
        this.attachmentDao.delete(attachmentId);
    }

    protected void updateTimestamps(Attachment attachment, String user) {
        Date now = new Date();
        if (attachment.getCreatedAt() == null) {
            attachment.setCreatedBy(user);
            attachment.setCreatedAt(now);
        }
        attachment.setModifiedBy(user);
        attachment.setModifiedAt(now);
    }
}

