/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.attachment.filter;

import java.io.File;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portlet.attachment.model.Attachment;
import org.jasig.portlet.attachment.service.IAttachmentService;
import org.jasig.portlet.attachment.util.DataUtil;
import org.jasig.portlet.attachment.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public final class LocalAttachmentFilter
implements Filter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAttachmentService attachmentService = null;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String relative = httpServletRequest.getServletPath();
        String path = httpServletRequest.getSession().getServletContext().getRealPath(relative);
        this.log.debug("Looking up file {}", (Object)path);
        File file = new File(path);
        if (!file.exists()) {
            int guidIndex;
            String[] parts = path.split("/");
            String guid = parts[guidIndex = parts.length - 2];
            Attachment attachment = this.attachmentService.get(guid);
            if (attachment != null) {
                this.log.debug("Restoring the following  attachment to the server file system:  {}", (Object)path);
                byte[] content = DataUtil.decode(attachment.getData());
                FileUtil.write(path, content);
                file = new File(path);
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                String contentType = httpServletRequest.getSession().getServletContext().getMimeType(path);
                httpResponse.setHeader("Content-Type", contentType);
                httpResponse.setDateHeader("Last-Modified", file.lastModified());
                httpResponse.setHeader("Content-Length", Long.toString(file.length()));
                httpResponse.setStatus(200);
                httpResponse.getOutputStream().write(content);
                httpResponse.flushBuffer();
                return;
            }
            this.log.info("Attachment not found: {}", (Object)path);
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

