/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.attachment.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.jasig.portlet.attachment.model.Attachment;
import org.jasig.portlet.attachment.service.IAttachmentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ImportExport {
    private static final String FILENAME_SUFFIX = ".attachment.xml";
    Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IAttachmentService attachmentService;
    @Value(value="${hibernate.connection.url}")
    private String hibernateURI;
    @Value(value="${hibernate.attachments.batch.fetch.size:100}")
    private int batchFetchSize = 100;

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            ImportExport.usage();
        }
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[]{"context/importExportContext.xml"});
        ImportExport importExport = (ImportExport)context.getBean("importExport");
        importExport.notifyUserIfUsingInMemoryDb();
        if ("export".equals(args[0])) {
            importExport.export(args[1]);
        } else if ("import".equalsIgnoreCase(args[0])) {
            importExport.importDir(args[1]);
        } else {
            ImportExport.usage();
        }
    }

    private void notifyUserIfUsingInMemoryDb() {
        if (this.hibernateURI.startsWith("jdbc:hsqldb:mem")) {
            this.log.warn("");
            this.log.warn("NOTICE:");
            this.log.warn("");
            this.log.warn("Operation aborted.  Update hibernate.properties. It is currently set to the in-memory DB.");
            this.log.warn("");
            System.exit(1);
        }
    }

    private void importDir(String directoryName) {
        File dir = this.checkIfDirExists(directoryName, false);
        Collection files = FileUtils.listFiles((File)dir, (IOFileFilter)new WildcardFileFilter("*.attachment.xml"), null);
        if (files.size() == 0) {
            this.log.info("No files of form {} to import in {}", (Object)"*.attachment.xml", (Object)directoryName);
        }
        for (File file : files) {
            this.importFile(file);
        }
    }

    private void importFile(File filename) {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Attachment.class});
            StreamSource xml = new StreamSource(filename);
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            JAXBElement je1 = unmarshaller.unmarshal((Source)xml, Attachment.class);
            Attachment attachment = (Attachment)je1.getValue();
            this.saveOrUpdate(attachment);
        }
        catch (JAXBException e) {
            this.log.error("Unable to import attachment {}", (Object)filename.getAbsolutePath(), (Object)e);
            System.exit(1);
        }
    }

    private void saveOrUpdate(Attachment attachment) {
        try {
            this.attachmentService.save(attachment, attachment.getModifiedBy() != null ? attachment.getModifiedBy() : "system");
            this.log.info("Imported attachment with guid {}", (Object)attachment.getGuid());
        }
        catch (DataAccessException e) {
            this.log.error("Unable to import attachment with guid {}", (Object)attachment.getGuid(), (Object)e);
            System.exit(1);
        }
    }

    private boolean export(String directoryName) {
        List attachments;
        boolean operationSucceeded = true;
        File dir = this.checkIfDirExists(directoryName, true);
        int offset = 0;
        do {
            if ((attachments = this.attachmentService.findAll(offset, this.batchFetchSize)).size() > 0) {
                try {
                    JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Attachment.class});
                    Marshaller marshaller = jc.createMarshaller();
                    marshaller.setProperty("jaxb.formatted.output", (Object)true);
                    for (Attachment attachment : attachments) {
                        File entityFile = new File(dir, attachment.getGuid() + ".attachment.xml");
                        this.log.info("Creating file " + entityFile.getAbsolutePath());
                        try {
                            JAXBElement je2 = new JAXBElement(new QName("Attachment"), Attachment.class, (Object)attachment);
                            marshaller.marshal((Object)je2, (Writer)new FileWriter(entityFile));
                        }
                        catch (IOException e) {
                            this.log.error("Unable to write to file {}", (Object)entityFile.getAbsolutePath(), (Object)e);
                            operationSucceeded = false;
                        }
                    }
                }
                catch (JAXBException e) {
                    this.log.error("Unable to create XML file", (Throwable)e);
                    System.exit(1);
                }
            }
            offset += attachments.size();
        } while (attachments.size() == this.batchFetchSize);
        if (attachments.size() == 0 && offset == 0) {
            this.log.info("No attachments found in the database.");
        }
        return operationSucceeded;
    }

    private File checkIfDirExists(String directoryName, boolean createIfAbsent) {
        File dir = new File(directoryName);
        if (!dir.exists() && createIfAbsent) {
            if (!dir.mkdirs()) {
                this.log.error("Unable to create directory at location {}", (Object)directoryName);
                System.exit(1);
            }
        } else if (dir.exists() && !dir.isDirectory()) {
            this.log.error("{} is not a directory", (Object)directoryName);
            System.exit(1);
        }
        return dir;
    }

    private static void usage() {
        System.out.println("Usage:");
        System.out.println("  java -Dlogback.configurationFile=command-line.logback.xml " + ImportExport.class.getCanonicalName() + " export <dir>");
        System.out.println("  java -Dlogback.configurationFile=command-line.logback.xml [-Ddir=<dir>] [-Dfile=<file>]" + ImportExport.class.getCanonicalName() + " import");
        System.exit(0);
    }
}

