/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.attachment.mvc;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.attachment.controller.AttachmentsController;
import org.jasig.portlet.attachment.model.Attachment;
import org.jasig.portlet.attachment.mvc.AttachmentServletRequestWrapper;
import org.jasig.portlet.attachment.service.IAttachmentService;
import org.jasig.portlet.attachment.util.FileUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
public final class LocalAttachmentController {
    private static final String RELATIVE_ROOT = "/content";
    private static final MessageFormat PATH_FORMAT = new MessageFormat("/content/{0}/{1}");
    @Autowired
    private IAttachmentService attachmentService = null;

    @RequestMapping(value={"/content/attach/local.json"}, method={RequestMethod.POST})
    public ModelAndView uploadForm(@RequestParam(value="qqfile") MultipartFile file, HttpServletRequest servletRequest) throws IOException {
        HashMap<String, String> model = new HashMap<String, String>();
        String user = (String)servletRequest.getSession().getAttribute(AttachmentsController.REMOTE_USER_ATTR);
        AttachmentServletRequestWrapper request = new AttachmentServletRequestWrapper(servletRequest, user);
        if (file != null) {
            Attachment attachment = LocalAttachmentController.generateAttachment((MultipartFile)file, (HttpServletRequest)request);
            if ((attachment = this.attachmentService.save(attachment, request.getRemoteUser())).getId() > 0L) {
                String path = this.getAttachmentAbsolutePath(attachment, (HttpServletRequest)request);
                FileUtil.write((String)path, (byte[])file.getBytes());
                model.put("id", Long.toString(attachment.getId()));
                model.put("guid", attachment.getGuid());
                model.put("path", attachment.getPath());
                model.put("filename", attachment.getFilename());
                model.put("success", "true");
            }
        }
        return new ModelAndView("jsonView", model);
    }

    @RequestMapping(value={"/content/attach/local"}, method={RequestMethod.POST}, produces={"text/plain"})
    public ModelAndView cKEditorUpload(@RequestParam(value="upload") MultipartFile file, @RequestParam(value="CKEditorFuncNum") String functionNumber, HttpServletRequest servletRequest) throws IOException {
        HashMap<String, String> model = new HashMap<String, String>();
        String user = (String)servletRequest.getSession().getAttribute(AttachmentsController.REMOTE_USER_ATTR);
        AttachmentServletRequestWrapper request = new AttachmentServletRequestWrapper(servletRequest, user);
        if (file != null) {
            Attachment attachment = LocalAttachmentController.generateAttachment((MultipartFile)file, (HttpServletRequest)request);
            if ((attachment = this.attachmentService.save(attachment, request.getRemoteUser())).getId() > 0L) {
                String path = this.getAttachmentAbsolutePath(attachment, (HttpServletRequest)request);
                FileUtil.write((String)path, (byte[])file.getBytes());
                model.put("functionNumber", functionNumber);
                model.put("attachment", (String)attachment);
            } else {
                throw new RuntimeException("Failure to upload attachment:  " + attachment.getFilename());
            }
        }
        return new ModelAndView("ckeditor-callback", model);
    }

    private String getAttachmentAbsolutePath(Attachment attachment, HttpServletRequest req) {
        String relative = PATH_FORMAT.format(new Object[]{attachment.getGuid(), attachment.getFilename()});
        String path = req.getSession().getServletContext().getRealPath(relative);
        return path;
    }

    private static Attachment generateAttachment(MultipartFile file, HttpServletRequest req) throws IOException {
        Attachment attachment = new Attachment();
        String fileNameParam = req.getParameter("filename");
        String filename = StringUtils.isEmpty((String)fileNameParam) ? file.getOriginalFilename() : fileNameParam;
        String context = req.getContextPath();
        String path = context + PATH_FORMAT.format(new Object[]{attachment.getGuid(), filename});
        String source = req.getParameter("source");
        attachment.setFilename(filename);
        attachment.setPath(path);
        attachment.setData(file.getBytes());
        attachment.setSource(StringUtils.isBlank((String)source) ? null : source);
        return attachment;
    }
}

