/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.attachment.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileUtil {
    private static final Log log = LogFactory.getLog(FileUtil.class);
    private static final List<String> locks = Collections.synchronizedList(new ArrayList());

    public static void write(String file, String content) throws IOException {
        FileUtil.write(file, content.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String file, byte[] content) throws IOException {
        while (locks.contains(file)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        locks.add(file);
        try {
            FileUtil.write(file);
            ByteArrayInputStream in = new ByteArrayInputStream(content);
            FileOutputStream out = new FileOutputStream(file);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            ((InputStream)in).close();
            out.close();
        }
        catch (Exception exception) {
            log.error((Object)("Unable to write file '" + file + "' to disk."), (Throwable)exception);
        }
        finally {
            locks.remove(file);
        }
    }

    public static void write(String path) throws IOException {
        File f = new File(path);
        if (!f.exists()) {
            if (f.isDirectory()) {
                f.mkdirs();
            } else {
                f.getParentFile().mkdirs();
                f.createNewFile();
            }
        }
    }

    public static byte[] read(URL url) throws IOException {
        if (url == null) {
            return null;
        }
        File file = new File(url.getFile());
        return FileUtil.read(file);
    }

    public static byte[] read(String path) throws IOException {
        if (StringUtils.isEmpty((String)path)) {
            return null;
        }
        File file = new File(path);
        return FileUtil.read(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] read(File file) throws IOException {
        if (file == null || !file.exists()) {
            return null;
        }
        if (locks.contains(file.getAbsolutePath())) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try (FileInputStream input = null;){
            input = new FileInputStream(file);
            int available = input.available();
            FileChannel channel = input.getChannel();
            ByteBuffer bytes = ByteBuffer.allocate(available);
            channel.read(bytes);
            bytes.flip();
            byte[] byArray = bytes.array();
            return byArray;
        }
    }
}

