/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.attachment.spring;

import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;

public class StringEncryptorFactoryBean
implements FactoryBean<StringEncryptor> {
    public static final String JAYSYPT_ENCRYPTION_KEY_VARIABLE = "UP_JASYPT_KEY";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public StringEncryptor getObject() throws Exception {
        StandardPBEStringEncryptor rslt = new StandardPBEStringEncryptor();
        String encryptionKey = System.getenv(JAYSYPT_ENCRYPTION_KEY_VARIABLE);
        if (encryptionKey != null) {
            this.logger.info("Jasypt support for encrypted property values ENABLED");
            rslt.setPassword(encryptionKey);
        } else {
            this.logger.info("Jasypt support for encrypted property values DISABLED;  specify environment variable {} to use this feature", (Object)JAYSYPT_ENCRYPTION_KEY_VARIABLE);
        }
        return rslt;
    }

    public Class<StringEncryptor> getObjectType() {
        return StringEncryptor.class;
    }

    public boolean isSingleton() {
        return false;
    }
}

