/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.attachment.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.jasig.portlet.attachment.model.Attachment;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;

public class SchemaCreator
implements ApplicationContextAware {
    private static final String APPLICATION_CONTEXT_LOCATION = "classpath:/context/baseContext.xml";
    private static final String DATA_SOURCE_BEAN_NAME = "dataSource";
    private ApplicationContext applicationContext;
    private final Logger logger = Logger.getLogger(this.getClass());

    public static void main(String[] args) {
        GenericApplicationContext context = new GenericApplicationContext();
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)context);
        Resource resource = context.getResource(APPLICATION_CONTEXT_LOCATION);
        reader.loadBeanDefinitions(resource);
        context.refresh();
        context.registerShutdownHook();
        SchemaCreator schemaCreator = (SchemaCreator)context.getBean("schemaCreator", SchemaCreator.class);
        System.exit(schemaCreator.create());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int create() {
        DataSource dataSource = (DataSource)this.applicationContext.getBean(DATA_SOURCE_BEAN_NAME, DataSource.class);
        try (Connection conn = dataSource.getConnection();){
            Configuration config = new Configuration();
            config.addAnnotatedClass(Attachment.class);
            SchemaExport schemaExport = new SchemaExport(config, conn);
            schemaExport.execute(true, true, false, false);
            List exceptions = schemaExport.getExceptions();
            if (exceptions.size() == 0) return 0;
            this.logger.error((Object)"Schema Create Failed;  see below for details");
            for (Exception e : exceptions) {
                this.logger.error((Object)"Exception from Hibernate Tools SchemaExport", (Throwable)e);
            }
            int n = 1;
            return n;
        }
        catch (SQLException sqle) {
            this.logger.error((Object)"Failed to initialize & invoke the SchemaExport tool", (Throwable)sqle);
            return 1;
        }
    }
}

