/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.cms.mvc.portlet;

import java.io.Serializable;
import java.util.Locale;
import javax.portlet.Event;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.jasig.portal.search.SearchConstants;
import org.jasig.portal.search.SearchRequest;
import org.jasig.portal.search.SearchResult;
import org.jasig.portal.search.SearchResults;
import org.jasig.portlet.cms.service.IStringCleaningService;
import org.jasig.portlet.cms.service.dao.IContentDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.EventMapping;
import org.springframework.web.portlet.context.PortletConfigAware;

@Controller
@RequestMapping(value={"VIEW"})
public class SearchContentController
implements PortletConfigAware {
    private int searchSummaryLength = 1000;
    private PortletConfig portletConfig;
    private IContentDao contentDao;
    private IStringCleaningService stringCleaningService;

    public void setSearchSummaryLength(int searchSummaryLength) {
        this.searchSummaryLength = searchSummaryLength;
    }

    @Autowired
    public void setContentDao(IContentDao contentDao) {
        this.contentDao = contentDao;
    }

    @Autowired
    public void setStringCleaningService(IStringCleaningService stringCleaningService) {
        this.stringCleaningService = stringCleaningService;
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }

    @EventMapping(value="{https://source.jasig.org/schemas/uportal/search}SearchRequest")
    public void searchContent(EventRequest request, EventResponse response) {
        String[] searchTerms;
        Event event = request.getEvent();
        SearchRequest searchQuery = (SearchRequest)event.getValue();
        String textContent = this.getTextContent((PortletRequest)request);
        for (String term : searchTerms = searchQuery.getSearchTerms().split(" ")) {
            if (!StringUtils.containsIgnoreCase((String)textContent, (String)term)) continue;
            SearchResults searchResults = new SearchResults();
            searchResults.setQueryId(searchQuery.getQueryId());
            searchResults.setWindowId(request.getWindowID());
            SearchResult searchResult = new SearchResult();
            String title = request.getPreferences().getValue("searchResultsTitle", "${portlet.title}");
            searchResult.setTitle(title);
            searchResult.setSummary(this.getContentSummary(textContent));
            searchResult.getType().add("Portlet Content");
            searchResults.getSearchResult().add(searchResult);
            response.setEvent(SearchConstants.SEARCH_RESULTS_QNAME, (Serializable)searchResults);
            return;
        }
    }

    protected String getContentSummary(String content) {
        if (content.length() > this.searchSummaryLength) {
            return content.substring(0, this.searchSummaryLength) + "...";
        }
        return content;
    }

    public String getTextContent(PortletRequest request) {
        Locale locale = request.getLocale();
        String content = this.contentDao.getContent(request, locale.toString());
        return this.stringCleaningService.getTextContent(content);
    }
}

