/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.attachment.service;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.codec.binary.Base64;
import org.jasig.portlet.attachment.model.Attachment;
import org.jasig.portlet.attachment.service.IDocumentPersistenceStrategy;
import org.jasig.portlet.attachment.service.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AmazonS3PersistenceStrategy
implements IDocumentPersistenceStrategy {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final MessageFormat PATH_FORMAT = new MessageFormat("{0}/{1}/{2}");
    @Value(value="${attachments.s3.bucket.name}")
    String s3BucketName;
    @Value(value="${attachments.s3.bucket.base.url}")
    String s3BucketBaseUrl;
    @Value(value="${attachments.s3.bucket.path:portlets/attachments}")
    String s3BucketPath;
    @Value(value="${attachments.s3.cache.control:private, max-age=2592000}")
    String s3CacheControlString;
    boolean persistenceIntoDatabaseRequired = false;

    @Override
    public String persistAttachmentBinary(HttpServletRequest request, Attachment attachment) throws PersistenceException {
        if (request == null && attachment.getData() == null) {
            return null;
        }
        AmazonS3Client s3 = new AmazonS3Client();
        String key = PATH_FORMAT.format(new Object[]{this.s3BucketPath, attachment.getGuid(), attachment.getFilename()});
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentType(attachment.getContentType());
        metadata.setContentLength((long)attachment.getData().length);
        metadata.setCacheControl(this.s3CacheControlString);
        metadata.setContentMD5(Base64.encodeBase64String((byte[])DatatypeConverter.parseHexBinary((String)attachment.getChecksum())));
        try {
            s3.putObject(new PutObjectRequest(this.s3BucketName, key, (InputStream)new ByteArrayInputStream(attachment.getData()), metadata));
            this.log.debug("Successfully sent {} to S3 bucket {} under key {}", new Object[]{attachment.getFilename(), this.s3BucketName, key});
        }
        catch (AmazonClientException e) {
            String message = String.format("Unable to persist attachment %1s to S3 bucket %2s, key %3s", attachment.getFilename(), this.s3BucketName, key);
            throw new PersistenceException(message, e);
        }
        return (this.s3BucketBaseUrl.endsWith("/") ? this.s3BucketBaseUrl : this.s3BucketBaseUrl + "/") + key;
    }

    public void setPersistenceIntoDatabaseRequired(boolean persistenceIntoDatabaseRequired) {
        this.persistenceIntoDatabaseRequired = persistenceIntoDatabaseRequired;
    }

    @Override
    public boolean isPersistenceIntoDatabaseRequired() {
        return this.persistenceIntoDatabaseRequired;
    }

    public String getS3BucketName() {
        return this.s3BucketName;
    }

    public void setS3BucketName(String s3BucketName) {
        this.s3BucketName = s3BucketName;
    }

    public String getS3BucketBaseUrl() {
        return this.s3BucketBaseUrl;
    }

    public void setS3BucketBaseUrl(String s3BucketBaseUrl) {
        this.s3BucketBaseUrl = s3BucketBaseUrl;
    }

    public String getS3BucketPath() {
        return this.s3BucketPath;
    }

    public void setS3BucketPath(String s3BucketPath) {
        this.s3BucketPath = s3BucketPath;
    }

    public String getS3CacheControlString() {
        return this.s3CacheControlString;
    }

    public void setS3CacheControlString(String s3CacheControlString) {
        this.s3CacheControlString = s3CacheControlString;
    }
}

