/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.attachment.service;

import java.io.IOException;
import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;
import org.jasig.portlet.attachment.model.Attachment;
import org.jasig.portlet.attachment.service.IDocumentPersistenceStrategy;
import org.jasig.portlet.attachment.service.PersistenceException;
import org.jasig.portlet.attachment.util.FileUtil;
import org.springframework.stereotype.Service;

@Service
public class FileSystemPersistenceStrategy
implements IDocumentPersistenceStrategy {
    private static final String RELATIVE_ROOT = "/content";
    private static final MessageFormat PATH_FORMAT = new MessageFormat("/content/{0}/{1}");

    @Override
    public String persistAttachmentBinary(HttpServletRequest request, Attachment attachment) throws PersistenceException {
        if (request == null) {
            return null;
        }
        String path = this.getAttachmentAbsolutePath(attachment, request);
        try {
            FileUtil.write(path, attachment.getData());
        }
        catch (IOException e) {
            throw new PersistenceException("Unable to persist file " + attachment.getFilename() + "to path " + path, e);
        }
        String context = request.getContextPath();
        String urlPath = context + PATH_FORMAT.format(new Object[]{attachment.getGuid(), attachment.getFilename()});
        return urlPath;
    }

    private String getAttachmentAbsolutePath(Attachment attachment, HttpServletRequest req) {
        String relative = PATH_FORMAT.format(new Object[]{attachment.getGuid(), attachment.getFilename()});
        String path = req.getSession().getServletContext().getRealPath(relative);
        return path;
    }

    @Override
    public boolean isPersistenceIntoDatabaseRequired() {
        return true;
    }
}

