/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.attachment.mvc;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.attachment.controller.AttachmentsController;
import org.jasig.portlet.attachment.model.Attachment;
import org.jasig.portlet.attachment.mvc.AttachmentServletRequestWrapper;
import org.jasig.portlet.attachment.service.IAttachmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
public final class LocalAttachmentController {
    @Autowired
    private IAttachmentService attachmentService = null;

    @RequestMapping(value={"/content/attach/local.json"}, method={RequestMethod.POST})
    public ModelAndView uploadForm(@RequestParam(value="qqfile") MultipartFile file, HttpServletRequest servletRequest) throws IOException {
        HashMap<String, String> model = new HashMap<String, String>();
        String user = (String)servletRequest.getSession().getAttribute(AttachmentsController.REMOTE_USER_ATTR);
        AttachmentServletRequestWrapper request = new AttachmentServletRequestWrapper(servletRequest, user);
        if (file != null) {
            Attachment attachment = LocalAttachmentController.generateAttachment((MultipartFile)file, (HttpServletRequest)request);
            if ((attachment = this.attachmentService.save(attachment, request.getRemoteUser(), servletRequest)).getId() > 0L) {
                model.put("id", Long.toString(attachment.getId()));
                model.put("guid", attachment.getGuid());
                model.put("path", attachment.getPath());
                model.put("filename", attachment.getFilename());
                model.put("success", "true");
            } else {
                throw new RuntimeException("Failure to upload attachment:  " + attachment.getFilename());
            }
        }
        return new ModelAndView("jsonView", model);
    }

    @RequestMapping(value={"/content/attach/local"}, method={RequestMethod.POST}, produces={"text/plain"})
    public ModelAndView cKEditorUpload(@RequestParam(value="upload") MultipartFile file, @RequestParam(value="CKEditorFuncNum") String functionNumber, HttpServletRequest servletRequest) throws IOException {
        HashMap<String, String> model = new HashMap<String, String>();
        String user = (String)servletRequest.getSession().getAttribute(AttachmentsController.REMOTE_USER_ATTR);
        AttachmentServletRequestWrapper request = new AttachmentServletRequestWrapper(servletRequest, user);
        if (file != null) {
            Attachment attachment = LocalAttachmentController.generateAttachment((MultipartFile)file, (HttpServletRequest)request);
            if ((attachment = this.attachmentService.save(attachment, request.getRemoteUser(), servletRequest)).getId() > 0L) {
                model.put("functionNumber", functionNumber);
                model.put("attachment", (String)attachment);
            } else {
                throw new RuntimeException("Failure to upload attachment:  " + attachment.getFilename());
            }
        }
        return new ModelAndView("ckeditor-callback", model);
    }

    private static Attachment generateAttachment(MultipartFile file, HttpServletRequest req) throws IOException {
        Attachment attachment = new Attachment();
        String fileNameParam = req.getParameter("filename");
        String filename = StringUtils.isEmpty((String)fileNameParam) ? file.getOriginalFilename() : fileNameParam;
        String source = req.getParameter("source");
        attachment.setFilename(filename);
        attachment.setData(file.getBytes());
        attachment.setChecksum(DigestUtils.md5Hex((byte[])attachment.getData()));
        attachment.setContentType(file.getContentType());
        attachment.setSource(StringUtils.isBlank((String)source) ? null : source);
        return attachment;
    }
}

