/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.attachment.service.impl;

import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.attachment.dao.IAttachmentDao;
import org.jasig.portlet.attachment.model.Attachment;
import org.jasig.portlet.attachment.service.IAttachmentService;
import org.jasig.portlet.attachment.service.IDocumentPersistenceStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class AttachmentService
implements IAttachmentService {
    @Autowired
    private IAttachmentDao attachmentDao;
    @Autowired
    @Qualifier(value="documentPersistenceStrategy")
    private IDocumentPersistenceStrategy documentPersistenceStrategy;

    public Attachment get(long attachmentId) {
        return this.attachmentDao.get(attachmentId);
    }

    public Attachment get(String guid) {
        return this.attachmentDao.get(guid);
    }

    public List<Attachment> find(String creator) {
        return this.attachmentDao.find(creator);
    }

    public List<Attachment> find(String creator, String filename) {
        return this.attachmentDao.find(creator, filename);
    }

    public List<Attachment> findAll(int offset, int maxresults) {
        return this.attachmentDao.findAll(offset, maxresults);
    }

    public Attachment save(Attachment attachment, String username, HttpServletRequest request) {
        Attachment existing;
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("Value for username cannot be blank;  is Tomcat's session path configured for shared sessions?");
        }
        String urlPath = this.documentPersistenceStrategy.persistAttachmentBinary(request, attachment);
        if (urlPath != null) {
            attachment.setPath(urlPath);
        }
        if (!this.documentPersistenceStrategy.isPersistenceIntoDatabaseRequired()) {
            attachment.setData(null);
        }
        if ((existing = this.attachmentDao.get(attachment.getGuid())) != null) {
            existing.setFilename(attachment.getFilename());
            existing.setPath(attachment.getPath());
            if (this.documentPersistenceStrategy.isPersistenceIntoDatabaseRequired()) {
                existing.setData(attachment.getData());
            }
            existing.setChecksum(attachment.getChecksum());
            existing.setSource(attachment.getSource());
            existing.setContentType(attachment.getContentType());
            attachment = existing;
        }
        this.updateTimestamps(attachment, username);
        Attachment saved = this.attachmentDao.save(attachment);
        return saved;
    }

    public void delete(Attachment attachment) {
        this.attachmentDao.delete(attachment);
    }

    public void delete(long attachmentId) {
        this.attachmentDao.delete(attachmentId);
    }

    protected void updateTimestamps(Attachment attachment, String user) {
        Date now = new Date();
        if (attachment.getCreatedAt() == null) {
            attachment.setCreatedBy(user);
            attachment.setCreatedAt(now);
        }
        attachment.setModifiedBy(user);
        attachment.setModifiedAt(now);
    }

    public IAttachmentDao getAttachmentDao() {
        return this.attachmentDao;
    }

    public void setAttachmentDao(IAttachmentDao attachmentDao) {
        this.attachmentDao = attachmentDao;
    }

    public IDocumentPersistenceStrategy getDocumentPersistenceStrategy() {
        return this.documentPersistenceStrategy;
    }

    public void setDocumentPersistenceStrategy(IDocumentPersistenceStrategy documentPersistenceStrategy) {
        this.documentPersistenceStrategy = documentPersistenceStrategy;
    }

    public boolean isPersistenceIntoDatabaseRequired() {
        return this.documentPersistenceStrategy.isPersistenceIntoDatabaseRequired();
    }
}

