/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.attachment.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.attachment.model.Attachment;
import org.jasig.portlet.attachment.service.IAttachmentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ImportExport {
    private static final String FILENAME_SUFFIX = ".attachment.xml";
    Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IAttachmentService attachmentService;
    @Value(value="${hibernate.connection.url}")
    private String hibernateURI;
    @Value(value="${hibernate.attachments.batch.fetch.size:100}")
    private int batchFetchSize = 100;

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            ImportExport.usage();
        }
        ApplicationContext context = ImportExport.bootstrapApplicationContext();
        ImportExport importExport = (ImportExport)context.getBean("importExport");
        importExport.notifyUserIfUsingInMemoryDb();
        if ("export".equals(args[0])) {
            importExport.export(args[1]);
        } else if ("import".equalsIgnoreCase(args[0])) {
            importExport.importDir(args[1]);
        } else {
            ImportExport.usage();
        }
    }

    public static ApplicationContext bootstrapApplicationContext() {
        return new ClassPathXmlApplicationContext(new String[]{"context/importExportContext.xml"});
    }

    private void notifyUserIfUsingInMemoryDb() {
        if (this.hibernateURI.startsWith("jdbc:hsqldb:mem")) {
            this.log.warn("");
            this.log.warn("NOTICE:");
            this.log.warn("");
            this.log.warn("Operation aborted.  Update hibernate.properties. It is currently set to the in-memory DB.");
            this.log.warn("");
            System.exit(1);
        }
    }

    private void importDir(String directoryName) {
        File dir = this.checkIfDirExists(directoryName, false);
        Collection files = FileUtils.listFiles((File)dir, (IOFileFilter)new WildcardFileFilter("*.attachment.xml"), (IOFileFilter)TrueFileFilter.INSTANCE);
        if (files.size() == 0) {
            this.log.info("No files of form {} to import in {}", (Object)"*.attachment.xml", (Object)directoryName);
        }
        boolean importSucceeded = true;
        for (File file : files) {
            importSucceeded &= this.importFile(file);
        }
        if (!importSucceeded) {
            System.exit(1);
        }
    }

    private boolean importFile(File filename) {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Attachment.class});
            StreamSource xml = new StreamSource(filename);
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            JAXBElement je1 = unmarshaller.unmarshal((Source)xml, Attachment.class);
            Attachment attachment = (Attachment)je1.getValue();
            if (attachment.getData() == null && !"true".equalsIgnoreCase(System.getProperty("importEmptySimpleContentData"))) {
                if (this.attachmentService.isPersistenceIntoDatabaseRequired()) {
                    this.log.error("Attachment with guid {} has no data and will be skipped.  This can occur if you had put SimpleContentPortlet v2.0.0+ on, uploaded attachments which wrote the data to the BDATA column instead of the deprecated DATA column, then went back to a pre 2.0.0 version to do the data-export.  Typically you do not want these records imported; they will be correct in the database if you are running import on the same database you ran export on.", (Object)attachment.getGuid());
                    return false;
                }
                this.log.info("Attachment with guid {} has no data. Should be OK since configured persistence store does not require persisting attachment data into a database. Saving attachment metadata into the database. Assume file is present at external location.", (Object)attachment.getGuid());
            }
            if (StringUtils.isBlank((String)attachment.getContentType())) {
                try {
                    String contentType = Files.probeContentType(FileSystems.getDefault().getPath(attachment.getFilename(), new String[0]));
                    if (!StringUtils.isNotBlank((String)contentType)) {
                        this.log.error("Unable to guess content type for item guid {}, filename {}", (Object)attachment.getGuid(), (Object)attachment.getFilename());
                        return false;
                    }
                    this.log.info("Guid {}, guessed content type {} for file {}", new Object[]{attachment.getGuid(), contentType, attachment.getFilename()});
                    attachment.setContentType(contentType);
                }
                catch (IOException e) {
                    this.log.error("Unable to guess content type for item guid {}, filename {}", new Object[]{attachment.getGuid(), attachment.getFilename(), e});
                    return false;
                }
            }
            this.saveOrUpdate(attachment);
        }
        catch (JAXBException e) {
            this.log.error("Unable to import attachment {}", (Object)filename.getAbsolutePath(), (Object)e);
            return false;
        }
        return true;
    }

    private void saveOrUpdate(Attachment attachment) {
        try {
            this.attachmentService.save(attachment, attachment.getModifiedBy() != null ? attachment.getModifiedBy() : "system", null);
            this.log.info("Imported attachment with guid {}", (Object)attachment.getGuid());
        }
        catch (DataAccessException e) {
            this.log.error("Unable to import attachment with guid {}", (Object)attachment.getGuid(), (Object)e);
            System.exit(1);
        }
    }

    private void export(String directoryName) {
        List attachments;
        boolean operationSucceeded = true;
        File dir = this.checkIfDirExists(directoryName, true);
        int offset = 0;
        do {
            if ((attachments = this.attachmentService.findAll(offset, this.batchFetchSize)).size() > 0) {
                try {
                    JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Attachment.class});
                    Marshaller marshaller = jc.createMarshaller();
                    marshaller.setProperty("jaxb.formatted.output", (Object)true);
                    for (Attachment attachment : attachments) {
                        File entityFile = new File(dir, attachment.getGuid() + ".attachment.xml");
                        if (attachment.getData() == null && this.attachmentService.isPersistenceIntoDatabaseRequired()) {
                            this.log.error("File {}, guid {} has no data.  This typically occurs if you are running export against a SimpleContentPortlet database prior to v2.0.0. You probably want to delete this file before running import and instead run export using a version prior to 2.0.0", (Object)entityFile.getAbsolutePath(), (Object)attachment.getGuid());
                            operationSucceeded = false;
                        } else {
                            this.log.info("Creating file {}", (Object)entityFile.getAbsolutePath());
                        }
                        try {
                            JAXBElement je2 = new JAXBElement(new QName("Attachment"), Attachment.class, (Object)attachment);
                            marshaller.marshal((Object)je2, (Writer)new FileWriter(entityFile));
                        }
                        catch (IOException e) {
                            this.log.error("Unable to write to file {}", (Object)entityFile.getAbsolutePath(), (Object)e);
                            operationSucceeded = false;
                        }
                    }
                }
                catch (JAXBException e) {
                    this.log.error("Unable to create XML file", (Throwable)e);
                    System.exit(1);
                }
            }
            offset += attachments.size();
        } while (attachments.size() == this.batchFetchSize);
        if (attachments.size() == 0 && offset == 0) {
            this.log.info("No attachments found in the database.");
        }
        if (!operationSucceeded) {
            System.exit(1);
        }
    }

    private File checkIfDirExists(String directoryName, boolean createIfAbsent) {
        File dir = new File(directoryName);
        if (!dir.exists() && createIfAbsent) {
            if (!dir.mkdirs()) {
                this.log.error("Unable to create directory at location {}", (Object)directoryName);
                System.exit(1);
            }
        } else if (dir.exists() && !dir.isDirectory()) {
            this.log.error("{} is not a directory", (Object)directoryName);
            System.exit(1);
        }
        return dir;
    }

    private static void usage() {
        System.out.println("Usage:");
        System.out.println("  java -Dlogback.configurationFile=command-line.logback.xml " + ImportExport.class.getCanonicalName() + " export <dir>");
        System.out.println("  java -Dlogback.configurationFile=command-line.logback.xml [-Ddir=<dir>] [-Dfile=<file>]" + ImportExport.class.getCanonicalName() + " import");
        System.exit(0);
    }
}

