/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.attachment.model;

import java.util.Date;
import java.util.UUID;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Index;

@Entity
@Table(name="SCM_ATTACHMENT")
@Inheritance(strategy=InheritanceType.JOINED)
@SequenceGenerator(name="SCM_ATTACHMENT_GEN", sequenceName="UP_ATTACHMENT_SEQ", allocationSize=1)
@TableGenerator(name="SCM_ATTACHMENT_GEN", pkColumnValue="UP_ATTACHMENT_PROP", allocationSize=1)
@org.hibernate.annotations.Table(appliesTo="SCM_ATTACHMENT", indexes={@Index(name="IDX_SCM_ATTACHMENT_FILENAME", columnNames={"FILENAME"}), @Index(name="IDX_SCM_ATTACHMENT_GUID", columnNames={"GUID"})})
@NamedQueries(value={@NamedQuery(name="Attachment.getByGuid", query="SELECT a FROM Attachment a WHERE a.guid = :guid"), @NamedQuery(name="Attachment.findByCreator", query="SELECT a FROM Attachment a WHERE a.createdBy = :creator"), @NamedQuery(name="Attachment.findByFilename", query="SELECT a FROM Attachment a WHERE a.createdBy = :creator AND a.filename = :filename"), @NamedQuery(name="Attachment.findAll", query="SELECT a FROM Attachment a order by a.id")})
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class Attachment {
    @Id
    @GeneratedValue(generator="SCM_ATTACHMENT_GEN")
    @Column(name="ID")
    private final long id;
    @Column(name="GUID", nullable=false, length=64)
    private String guid = UUID.randomUUID().toString();
    @Column(name="FILENAME", nullable=false, length=128)
    private String filename;
    @Column(name="PATH", nullable=false, length=255)
    private String path;
    @Column(name="SOURCE", nullable=true, length=255)
    private String source;
    @Lob
    @Column(name="BDATA", nullable=true, length=0x7FFFFFFF)
    private byte[] data;
    @Column(name="CHECKSUM", nullable=false, length=32)
    private String checksum = "0";
    @Column(name="CREATED_BY", nullable=false, length=128)
    private String createdBy;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="CREATED_AT", nullable=false)
    private Date createdAt;
    @Column(name="MODIFIED_BY", nullable=false, length=128)
    private String modifiedBy;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="MODIFIED_AT", nullable=false)
    private Date modifiedAt;
    @Column(name="CONTENT_TYPE", nullable=true, length=128)
    private String contentType;

    public Attachment() {
        this.id = -1L;
    }

    public long getId() {
        return this.id;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] bdata) {
        this.data = bdata;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public Date getModifiedAt() {
        return this.modifiedAt;
    }

    public void setModifiedAt(Date modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
}

