/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.survey.service.dto;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.jasig.portlet.survey.service.dto.ResponseAnswerDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResponseAnswerDtoDeserializer
extends JsonDeserializer<ResponseAnswerDTO> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public ResponseAnswerDTO deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        this.log.debug("deserializing responseAnswer JSON");
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        ResponseAnswerDTO dto = new ResponseAnswerDTO();
        JsonNode questionNode = node.get("question");
        this.log.debug(questionNode.toString());
        if (questionNode == null || !questionNode.canConvertToLong()) {
            throw new IllegalArgumentException("ResponseAnswer Json missing/bad question field");
        }
        Long questionId = questionNode.asLong();
        dto.setQuestion(questionId);
        JsonNode answerNode = node.get("answer");
        if (answerNode == null) {
            throw new IllegalArgumentException("ResponseAnswer Json missing answer field");
        }
        if (answerNode.canConvertToLong()) {
            dto.addAnswerId(answerNode.asLong());
        } else if (answerNode.isObject()) {
            Iterator fields = answerNode.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                Long answerId = Long.parseLong((String)field.getKey());
                assert (((JsonNode)field.getValue()).isBoolean());
                boolean answerSelected = ((JsonNode)field.getValue()).asBoolean(false);
                if (!answerSelected) continue;
                dto.addAnswerId(answerId);
            }
        } else {
            throw new IllegalArgumentException("ResponseAnswer Json bad answer argument field");
        }
        return dto;
    }
}

