/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.survey.service.jpa;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.jasig.portlet.survey.service.jpa.IJpaSurveyDao;
import org.jasig.portlet.survey.service.jpa.JpaAnswer;
import org.jasig.portlet.survey.service.jpa.JpaQuestion;
import org.jasig.portlet.survey.service.jpa.JpaQuestionAnswer;
import org.jasig.portlet.survey.service.jpa.JpaResponse;
import org.jasig.portlet.survey.service.jpa.JpaSurvey;
import org.jasig.portlet.survey.service.jpa.JpaSurveyQuestion;
import org.jasig.portlet.survey.service.jpa.JpaSurveyQuestionPK;
import org.jasig.portlet.survey.service.jpa.JpaSurveyText;
import org.jasig.portlet.survey.service.jpa.repo.JpaAnswerRepository;
import org.jasig.portlet.survey.service.jpa.repo.JpaQuestionAnswerRepository;
import org.jasig.portlet.survey.service.jpa.repo.JpaQuestionRepository;
import org.jasig.portlet.survey.service.jpa.repo.JpaResponseAnswerRepository;
import org.jasig.portlet.survey.service.jpa.repo.JpaResponseRepository;
import org.jasig.portlet.survey.service.jpa.repo.JpaSurveyQuestionRepository;
import org.jasig.portlet.survey.service.jpa.repo.JpaSurveyRepository;
import org.jasig.portlet.survey.service.jpa.repo.JpaSurveyTextRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
class JpaSurveyDao
implements IJpaSurveyDao {
    @Autowired
    private JpaAnswerRepository answerRepository;
    @Autowired
    private JpaQuestionAnswerRepository qaRepository;
    @Autowired
    private JpaQuestionRepository questionRepository;
    @Autowired
    private JpaSurveyQuestionRepository surveyQuestionRepository;
    @Autowired
    private JpaSurveyRepository surveyRepository;
    @Autowired
    private JpaResponseRepository responseRepository;
    @Autowired
    private JpaResponseAnswerRepository responseAnswerRepository;
    @Autowired
    private JpaSurveyTextRepository surveyTextRepository;

    JpaSurveyDao() {
    }

    @Override
    public JpaSurveyQuestion attachQuestionToSurvey(Long surveyId, Long questionId, JpaSurveyQuestion surveyQuestion) {
        JpaSurvey survey = this.getSurvey(surveyId);
        JpaQuestion question = this.getQuestion(questionId);
        survey.setLastUpdateDate(new Timestamp(new Date().getTime()));
        JpaSurveyQuestionPK pk = new JpaSurveyQuestionPK(question, survey);
        surveyQuestion.setId(pk);
        survey.addJpaSurveyQuestion(surveyQuestion);
        this.surveyRepository.save(survey);
        return surveyQuestion;
    }

    @Override
    public JpaAnswer createAnswer(JpaAnswer answer) {
        JpaAnswer newAnswer = (JpaAnswer)this.answerRepository.save(answer);
        return newAnswer;
    }

    @Override
    public JpaQuestion createQuestion(JpaQuestion question) {
        this.setupQuestionForSave(question, true);
        JpaQuestion q = (JpaQuestion)this.questionRepository.save(question);
        return q;
    }

    @Override
    public JpaQuestionAnswer createQuestionAnswer(JpaQuestion question, JpaAnswer answer, Integer sequence) {
        JpaQuestionAnswer newQa = new JpaQuestionAnswer();
        newQa.getId().setJpaAnswer(answer);
        newQa.getId().setJpaQuestion(question);
        newQa = (JpaQuestionAnswer)this.qaRepository.save(newQa);
        return newQa;
    }

    @Override
    public JpaSurvey createSurvey(JpaSurvey survey) {
        List<JpaSurveyQuestion> sqList = survey.getJpaSurveyQuestions();
        if (sqList != null && !sqList.isEmpty()) {
            for (JpaSurveyQuestion sq : sqList) {
                sq.getId().setJpaSurvey(survey);
                JpaQuestion q = sq.getId().getJpaQuestion();
                this.setupQuestionForSave(q, true);
                q = this.createQuestion(q);
                sq.getId().setJpaQuestion(q);
            }
        }
        JpaSurvey s = (JpaSurvey)this.surveyRepository.save(survey);
        return s;
    }

    @Override
    public JpaSurveyText createSurveyText(JpaSurveyText text) {
        JpaSurveyText newSurveyText = (JpaSurveyText)this.surveyTextRepository.save(text);
        return newSurveyText;
    }

    @Override
    public List<JpaSurvey> getAllSurveys() {
        Iterable surveyIter = this.surveyRepository.findAll();
        List surveyList = IteratorUtils.toList(surveyIter.iterator());
        return surveyList;
    }

    @Override
    public JpaQuestion getQuestion(Long id) {
        JpaQuestion question = (JpaQuestion)this.questionRepository.findOne(id);
        return question;
    }

    @Override
    public JpaAnswer getAnswer(Long id) {
        JpaAnswer answer = (JpaAnswer)this.answerRepository.findOne(id);
        return answer;
    }

    @Override
    public JpaSurvey getSurvey(Long id) {
        Validate.isTrue((id > 0L ? 1 : 0) != 0, (String)("Invalid survey id: " + id));
        JpaSurvey survey = (JpaSurvey)this.surveyRepository.findOne(id);
        return survey;
    }

    @Override
    public JpaSurvey getSurveyByCanonicalName(String canonicalName) {
        if (StringUtils.isEmpty((String)canonicalName)) {
            return null;
        }
        return this.surveyRepository.findByCanonicalName(canonicalName);
    }

    @Override
    public JpaSurveyText getText(String key, String variant) {
        if (StringUtils.isEmpty((String)key)) {
            return new JpaSurveyText();
        }
        JpaSurveyText result = this.surveyTextRepository.findByKeyAndVariant(key, StringUtils.trimToEmpty((String)variant));
        return result == null ? new JpaSurveyText() : result;
    }

    private void setupQuestionForSave(JpaQuestion jpaQuestion, boolean createAnswer) {
        Set<JpaQuestionAnswer> qaList = jpaQuestion.getJpaQuestionAnswers();
        if (qaList != null && !qaList.isEmpty()) {
            for (JpaQuestionAnswer qa : qaList) {
                JpaAnswer answer = qa.getId().getJpaAnswer();
                this.createAnswer(answer);
                qa.getId().setJpaQuestion(jpaQuestion);
                qa.getId().setJpaAnswer(answer);
                if (jpaQuestion.getId() == 0L) continue;
                JpaQuestionAnswer existingQA = (JpaQuestionAnswer)this.qaRepository.findOne(qa.getId());
                if (existingQA != null) {
                    existingQA.setSequence(qa.getSequence());
                    existingQA.setLogic(qa.getLogic());
                    existingQA.setCanonicalName(qa.getCanonicalName());
                    this.qaRepository.save(existingQA);
                    continue;
                }
                this.qaRepository.save(qa);
            }
        }
    }

    @Override
    public JpaQuestion updateQuestion(JpaQuestion question) {
        this.setupQuestionForSave(question, false);
        return (JpaQuestion)this.questionRepository.save(question);
    }

    @Override
    public JpaSurvey updateSurvey(JpaSurvey survey) {
        return (JpaSurvey)this.surveyRepository.save(survey);
    }

    @Override
    public JpaResponse createResponse(JpaResponse jpaResponse) {
        return (JpaResponse)this.responseRepository.save(jpaResponse);
    }

    @Override
    public JpaResponse getResponse(long id) {
        return (JpaResponse)this.responseRepository.findOne(Long.valueOf(id));
    }

    @Override
    public List<JpaResponse> getResponseByUser(String user) {
        List<JpaResponse> responseIter = this.responseRepository.findByUser(user);
        return IteratorUtils.toList(responseIter.iterator());
    }

    @Override
    public JpaResponse getResponseByUserAndSurvey(String user, long surveyId) {
        List<JpaResponse> responseIter = this.responseRepository.findByUserAndSurvey(user, surveyId);
        return responseIter.iterator().hasNext() ? (JpaResponse)responseIter.iterator().next() : null;
    }

    @Override
    public JpaResponse updateResponse(JpaResponse jpaResponse) {
        return (JpaResponse)this.responseRepository.save(jpaResponse);
    }

    @Override
    public List<JpaResponse> getResponseBySurvey(Long surveyId) {
        return this.responseRepository.findBySurvey(surveyId);
    }
}

