/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.survey.mvc.service;

import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.jasig.portlet.survey.IVariantStrategy;
import org.jasig.portlet.survey.PublishedState;
import org.jasig.portlet.survey.mvc.service.ISurveyDataService;
import org.jasig.portlet.survey.service.dto.AnswerDTO;
import org.jasig.portlet.survey.service.dto.ITextGroup;
import org.jasig.portlet.survey.service.dto.QuestionDTO;
import org.jasig.portlet.survey.service.dto.ResponseDTO;
import org.jasig.portlet.survey.service.dto.SurveyDTO;
import org.jasig.portlet.survey.service.dto.SurveyQuestionDTO;
import org.jasig.portlet.survey.service.dto.SurveySummaryDTO;
import org.jasig.portlet.survey.service.jpa.IJpaSurveyDao;
import org.jasig.portlet.survey.service.jpa.ISurveyMapper;
import org.jasig.portlet.survey.service.jpa.JpaQuestion;
import org.jasig.portlet.survey.service.jpa.JpaResponse;
import org.jasig.portlet.survey.service.jpa.JpaSurvey;
import org.jasig.portlet.survey.service.jpa.JpaSurveyQuestion;
import org.jasig.portlet.survey.service.jpa.JpaSurveyText;
import org.jasig.portlet.survey.service.jpa.JpaSurveyTextPK;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JpaSurveyDataService
implements ISurveyDataService {
    public static final String TABLENAME_PREFIX = "SURVEY_";
    @Autowired
    private IJpaSurveyDao jpaSurveyDao;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISurveyMapper surveyMapper;
    @Autowired
    private IVariantStrategy variantStrategy;

    @Override
    @Transactional
    public boolean addQuestionToSurvey(Long surveyId, Long questionId, SurveyQuestionDTO surveyQuestion) {
        Validate.isTrue((surveyId != null && questionId != null ? 1 : 0) != 0, (String)"Survey and question cannot be null");
        JpaSurveyQuestion sq = new JpaSurveyQuestion();
        sq.setNumAllowedAnswers(surveyQuestion.getNumAllowedAnswers());
        sq.setSequence(surveyQuestion.getSequence());
        JpaSurveyQuestion newSurveyQuestion = this.jpaSurveyDao.attachQuestionToSurvey(surveyId, questionId, sq);
        return newSurveyQuestion != null;
    }

    @Override
    @Transactional
    public AnswerDTO createAnswerForQuestion(Long questionId, AnswerDTO answer) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    @Transactional
    public QuestionDTO createQuestion(QuestionDTO question) {
        JpaQuestion jpaQuestion = this.surveyMapper.toJpaQuestion(question);
        jpaQuestion = this.jpaSurveyDao.createQuestion(jpaQuestion);
        QuestionDTO newQuestion = this.surveyMapper.toQuestion(jpaQuestion);
        return newQuestion;
    }

    @Override
    @Transactional
    public SurveyDTO createSurvey(SurveyDTO survey) {
        JpaSurvey jpaSurvey = this.surveyMapper.toJpaSurvey(survey);
        jpaSurvey.setLastUpdateDate(new Timestamp(new Date().getTime()));
        jpaSurvey = this.jpaSurveyDao.createSurvey(jpaSurvey);
        return this.surveyMapper.toSurvey(jpaSurvey);
    }

    @Override
    @Transactional
    public ITextGroup createTextGroup(ITextGroup textGroup) {
        JpaSurveyText jpaSurveyText = new JpaSurveyText();
        JpaSurveyTextPK newId = new JpaSurveyTextPK();
        newId.setKey(textGroup.getKey());
        newId.setVariant(textGroup.getVariant());
        jpaSurveyText.setId(newId);
        jpaSurveyText.setAltText(textGroup.getAltText());
        jpaSurveyText.setDefinitionText(textGroup.getDefinitionText());
        jpaSurveyText.setHelpText(textGroup.getHelpText());
        jpaSurveyText.setText(textGroup.getText());
        return this.jpaSurveyDao.createSurveyText(jpaSurveyText);
    }

    @Override
    @Transactional(readOnly=true, propagation=Propagation.REQUIRED)
    public List<SurveyDTO> getAllSurveys() {
        List<JpaSurvey> surveyList = this.jpaSurveyDao.getAllSurveys();
        if (surveyList == null) {
            return null;
        }
        List<SurveyDTO> results = this.surveyMapper.toSurveyList(surveyList);
        for (SurveyDTO surveyDTO : results) {
            surveyDTO.retrieveText(this);
        }
        return results;
    }

    @Override
    @Transactional(readOnly=true, propagation=Propagation.REQUIRED)
    public SurveyDTO getSurvey(long id) {
        JpaSurvey jpaSurvey = this.jpaSurveyDao.getSurvey(id);
        if (jpaSurvey == null) {
            return null;
        }
        SurveyDTO result = this.surveyMapper.toSurvey(jpaSurvey);
        result.retrieveText(this);
        return result;
    }

    @Override
    @Transactional(readOnly=true, propagation=Propagation.REQUIRED)
    public SurveyDTO getSurveyByName(String surveyName) {
        JpaSurvey jpaSurvey = this.jpaSurveyDao.getSurveyByCanonicalName(surveyName);
        if (jpaSurvey == null) {
            return null;
        }
        SurveyDTO result = this.surveyMapper.toSurvey(jpaSurvey);
        result.retrieveText(this);
        return result;
    }

    @Override
    @Transactional(readOnly=true, propagation=Propagation.REQUIRED)
    public List<SurveyQuestionDTO> getSurveyQuestions(Long surveyId) {
        JpaSurvey survey = this.jpaSurveyDao.getSurvey(surveyId);
        if (survey == null) {
            return null;
        }
        SurveyDTO surveyDTO = this.surveyMapper.toSurvey(survey);
        return Lists.newArrayList(surveyDTO.getSurveyQuestions());
    }

    @Override
    @Transactional(readOnly=true, propagation=Propagation.REQUIRED)
    public ITextGroup getTextGroup(String textKey) {
        return this.jpaSurveyDao.getText(textKey, this.variantStrategy.getVariantName());
    }

    @Override
    @Transactional
    public QuestionDTO updateQuestion(QuestionDTO question) {
        JpaQuestion existingQuestion = this.jpaSurveyDao.getQuestion(question.getId());
        if (existingQuestion.getStatus() == PublishedState.PUBLISHED) {
            this.log.warn("Cannot update question in PUBLISHED state");
            return null;
        }
        JpaQuestion jpaQuestion = this.surveyMapper.toJpaQuestion(question);
        this.jpaSurveyDao.updateQuestion(jpaQuestion);
        return this.surveyMapper.toQuestion(jpaQuestion);
    }

    @Override
    @Transactional
    public SurveyDTO updateSurvey(SurveyDTO survey) {
        JpaSurvey existingSurvey = this.jpaSurveyDao.getSurvey(survey.getId());
        if (existingSurvey == null || existingSurvey.getStatus() == PublishedState.PUBLISHED) {
            this.log.warn("Cannot update survey");
            return null;
        }
        survey.setSurveyQuestions(null);
        JpaSurvey jpaSurvey = this.surveyMapper.toJpaSurvey(survey);
        jpaSurvey.setLastUpdateDate(new Timestamp(new Date().getTime()));
        jpaSurvey = this.jpaSurveyDao.updateSurvey(jpaSurvey);
        return this.surveyMapper.toSurvey(jpaSurvey);
    }

    @Override
    @Transactional
    public ResponseDTO createResponse(ResponseDTO response) {
        this.log.debug("Entering createResponse()");
        JpaResponse jpaResponse = this.surveyMapper.toJpaResponse(response);
        this.log.debug(jpaResponse.toString());
        jpaResponse.setLastUpdated(new Date());
        this.jpaSurveyDao.createResponse(jpaResponse);
        this.log.debug("About to leave createResponse()");
        return this.surveyMapper.toResponse(jpaResponse);
    }

    @Override
    @Transactional(readOnly=true, propagation=Propagation.REQUIRED)
    public ResponseDTO getResponse(long id) {
        JpaResponse jpaResponse = this.jpaSurveyDao.getResponse(id);
        this.log.debug(jpaResponse.toString());
        return jpaResponse == null ? null : this.surveyMapper.toResponse(jpaResponse);
    }

    @Override
    @Transactional(readOnly=true, propagation=Propagation.REQUIRED)
    public List<ResponseDTO> getResponseByUser(String user) {
        List<JpaResponse> responseList = this.jpaSurveyDao.getResponseByUser(user);
        if (responseList == null) {
            return null;
        }
        return this.surveyMapper.toResponseList(responseList);
    }

    @Override
    @Transactional(readOnly=true, propagation=Propagation.REQUIRED)
    public ResponseDTO getResponseByUserAndSurvey(String user, long surveyId) {
        JpaResponse jpaResponse = this.jpaSurveyDao.getResponseByUserAndSurvey(user, surveyId);
        return jpaResponse == null ? null : this.surveyMapper.toResponse(jpaResponse);
    }

    @Override
    @Transactional
    public ResponseDTO updateResponse(ResponseDTO response) {
        JpaResponse existingResponse = this.jpaSurveyDao.getResponse(response.getId());
        if (existingResponse == null) {
            this.log.warn("Cannot update response - does not exist", (Object)response.toString());
            return null;
        }
        JpaResponse jpaResponse = this.surveyMapper.toJpaResponse(response);
        this.log.debug("existing response: " + existingResponse.toString());
        this.log.debug("source DTO response: " + response.toString());
        this.log.debug("mapped response: " + jpaResponse.toString());
        jpaResponse.setLastUpdated(new Date());
        jpaResponse = this.jpaSurveyDao.updateResponse(jpaResponse);
        this.log.debug("updated response: " + jpaResponse.toString());
        return this.surveyMapper.toResponse(jpaResponse);
    }

    @Override
    @Transactional(readOnly=true, propagation=Propagation.REQUIRED)
    public SurveySummaryDTO getSurveySummary(Long surveyId) {
        List<JpaResponse> responses = this.jpaSurveyDao.getResponseBySurvey(surveyId);
        SurveySummaryDTO summary = new SurveySummaryDTO(responses);
        this.log.debug(summary.toString());
        return summary;
    }
}

