/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.survey.service.dto;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jasig.portlet.survey.service.jpa.JpaAnswer;
import org.jasig.portlet.survey.service.jpa.JpaResponse;
import org.jasig.portlet.survey.service.jpa.JpaResponseAnswer;
import org.jasig.portlet.survey.service.jpa.JpaResponseAnswerPK;
import org.jsondoc.core.annotation.ApiObject;

@ApiObject(name="SurveySummaryDTO")
public class SurveySummaryDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long responseCount = 0L;
    private Map<String, Map<String, Long>> answerCounts;

    public SurveySummaryDTO(List<JpaResponse> responses) {
        this.responseCount = responses.size();
        this.answerCounts = new HashMap<String, Map<String, Long>>();
        for (JpaResponse response : responses) {
            for (JpaResponseAnswer respAnswer : response.getJpaResponseAnswers()) {
                JpaResponseAnswerPK pk = respAnswer.getId();
                String question = respAnswer.getId().getJpaQuestion().getText();
                Map<String, Long> answerCount = this.answerCounts.get(question);
                if (answerCount == null) {
                    answerCount = new HashMap<String, Long>();
                    this.answerCounts.put(question, answerCount);
                }
                for (JpaAnswer answer : respAnswer.getAnswer()) {
                    Long count = answerCount.get(answer.getText());
                    count = count == null ? new Long(1L) : Long.valueOf(count + 1L);
                    answerCount.put(answer.getText(), count);
                }
            }
        }
    }

    public long getResponseCount() {
        return this.responseCount;
    }

    public Map<String, Map<String, Long>> getAnswerCounts() {
        return this.answerCounts;
    }

    public boolean equals(Object that) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)that, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

