/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.survey.service.jpa;

import java.io.Serializable;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.hibernate.annotations.Type;
import org.jasig.portlet.survey.PublishedState;
import org.jasig.portlet.survey.service.jpa.JpaQuestionAnswer;
import org.jasig.portlet.survey.service.jpa.JpaSurveyQuestion;

@Entity
@Table(name="SURVEY_QUESTION")
public class JpaQuestion
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="ALT_TEXT", nullable=true)
    private String altText;
    @Column(name="CANONICAL_NAME", nullable=true, unique=true)
    private String canonicalName;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    @Column(name="HELP_TEXT", nullable=true)
    private String helpText;
    @SequenceGenerator(name="SURVEY_QUESTION_GEN", sequenceName="SURVEY_QUESTION_SEQ", allocationSize=5)
    @TableGenerator(name="SURVEY_QUESTION_GEN", pkColumnValue="SURVEY_QUESTION", allocationSize=5)
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SURVEY_QUESTION_GEN")
    @Column(name="ID", updatable=false)
    private long id;
    @OneToMany(mappedBy="id.jpaQuestion", fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    private Set<JpaQuestionAnswer> jpaQuestionAnswers;
    @Column(name="STATUS", nullable=false)
    private PublishedState status;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    @Column(name="TEXT", nullable=false)
    private String text;

    public JpaQuestionAnswer addJpaQuestionAnswer(JpaQuestionAnswer jpaQuestionAnswer) {
        this.getJpaQuestionAnswers().add(jpaQuestionAnswer);
        jpaQuestionAnswer.getId().setJpaQuestion(this);
        return jpaQuestionAnswer;
    }

    public JpaSurveyQuestion addJpaSurveyQuestion(JpaSurveyQuestion jpaSurveyQuestion) {
        jpaSurveyQuestion.getId().setJpaQuestion(this);
        return jpaSurveyQuestion;
    }

    public String getAltText() {
        return this.altText;
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public long getId() {
        return this.id;
    }

    public Set<JpaQuestionAnswer> getJpaQuestionAnswers() {
        return this.jpaQuestionAnswers;
    }

    public PublishedState getStatus() {
        return this.status;
    }

    public String getText() {
        return this.text;
    }

    public JpaQuestionAnswer removeJpaQuestionAnswer(JpaQuestionAnswer jpaQuestionAnswer) {
        this.getJpaQuestionAnswers().remove(jpaQuestionAnswer);
        jpaQuestionAnswer.getId().setJpaQuestion(null);
        return jpaQuestionAnswer;
    }

    public JpaSurveyQuestion removeJpaSurveyQuestion(JpaSurveyQuestion jpaSurveyQuestion) {
        jpaSurveyQuestion.getId().setJpaQuestion(null);
        return jpaSurveyQuestion;
    }

    public void setAltText(String altText) {
        this.altText = altText;
    }

    public void setCanonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
    }

    public void setHelpText(String helpText) {
        this.helpText = helpText;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setJpaQuestionAnswers(Set<JpaQuestionAnswer> jpaQuestionAnswers) {
        this.jpaQuestionAnswers = jpaQuestionAnswers;
    }

    public void setStatus(PublishedState status) {
        this.status = status;
    }

    public void setText(String text) {
        this.text = text;
    }
}

