/**
 * Licensed to Apereo under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Apereo licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License.  You may obtain a
 * copy of the License at the following location:
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.jasig.portlet.survey.security;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationProvider;

/**
 *
 * @author mglazier
 */
@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class SecurityConfig extends WebSecurityConfigurerAdapter {

    final private PreAuthenticatedAuthenticationProvider preAuthenticatedProvider;
    final private UportalPreAuthenticatedProcessingFilter processingFilter;

    @Autowired
    private PortalPreAuthenticatedUserDetailsService detailsService;

    public SecurityConfig() {
        preAuthenticatedProvider = new PreAuthenticatedAuthenticationProvider();
        processingFilter = new UportalPreAuthenticatedProcessingFilter();
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        preAuthenticatedProvider.setPreAuthenticatedUserDetailsService(detailsService);
        auth.authenticationProvider(preAuthenticatedProvider);
    }

    @Override
    protected void configure(HttpSecurity http) throws Exception {
        processingFilter.setAuthenticationManager( authenticationManager());

        http
            .jee()
                .j2eePreAuthenticatedProcessingFilter(processingFilter)
                .and()
            .sessionManagement()
                .sessionFixation().none()
                .sessionCreationPolicy(SessionCreationPolicy.NEVER)
                .and()
            .csrf()
                .disable();

    }

}
