/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.survey.security.uportal;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.portlet.PortletException;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.filter.FilterChain;
import javax.portlet.filter.FilterConfig;
import javax.portlet.filter.RenderFilter;
import org.jasig.portlet.survey.security.UPortalUserDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public final class UPortalSecurityFilter
implements RenderFilter {
    public static final String ROLE_SURVEY_ADMIN = "ROLE_SURVEY_ADMIN";
    public static final String ROLE_SURVEY_USER = "ROLE_SURVEY_USER";
    public static final String AUTHENTICATION_TOKEN_KEY = UPortalSecurityFilter.class.getName() + ".GRANTED_AUTHORITIES_KEY";
    public static final Object SSP_OWNER = "SSP";
    private static final Logger logger = LoggerFactory.getLogger(UPortalSecurityFilter.class);

    public void doFilter(RenderRequest req, RenderResponse res, FilterChain chain) throws IOException, PortletException {
        PortletSession session;
        Set authorities;
        String principal = req.getRemoteUser();
        if (principal != null && (authorities = (Set)(session = req.getPortletSession()).getAttribute(AUTHENTICATION_TOKEN_KEY)) == null) {
            this.populateAuthorites(req, principal);
        }
        chain.doFilter(req, res);
    }

    private void populateAuthorites(RenderRequest req, String principal) {
        boolean isSurveyUser;
        HashSet<SimpleGrantedAuthority> authorities = new HashSet<SimpleGrantedAuthority>();
        boolean isSurveyAdmin = req.isUserInRole("survey-admin");
        if (isSurveyAdmin) {
            authorities.add(new SimpleGrantedAuthority(ROLE_SURVEY_ADMIN));
        }
        if (isSurveyUser = req.isUserInRole("survey-user")) {
            authorities.add(new SimpleGrantedAuthority(ROLE_SURVEY_USER));
        }
        logger.debug("Setting up GrantedAutorities for user '{}' -- {}", (Object)principal, (Object)((Object)authorities).toString());
        UPortalUserDetails userDetails = new UPortalUserDetails(principal, Collections.unmodifiableSet(authorities));
        PortletSession session = req.getPortletSession();
        session.setAttribute(AUTHENTICATION_TOKEN_KEY, (Object)userDetails, 1);
    }

    public void init(FilterConfig config) throws PortletException {
    }

    public void destroy() {
    }
}

