/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.survey.service.jpa;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import org.dozer.Mapper;
import org.jasig.portlet.survey.service.dto.AnswerDTO;
import org.jasig.portlet.survey.service.dto.QuestionAnswerDTO;
import org.jasig.portlet.survey.service.dto.QuestionDTO;
import org.jasig.portlet.survey.service.dto.ResponseAnswerDTO;
import org.jasig.portlet.survey.service.dto.ResponseDTO;
import org.jasig.portlet.survey.service.dto.SurveyDTO;
import org.jasig.portlet.survey.service.jpa.IJpaSurveyDao;
import org.jasig.portlet.survey.service.jpa.ISurveyMapper;
import org.jasig.portlet.survey.service.jpa.JpaAnswer;
import org.jasig.portlet.survey.service.jpa.JpaQuestion;
import org.jasig.portlet.survey.service.jpa.JpaQuestionAnswer;
import org.jasig.portlet.survey.service.jpa.JpaResponse;
import org.jasig.portlet.survey.service.jpa.JpaResponseAnswer;
import org.jasig.portlet.survey.service.jpa.JpaResponseAnswerPK;
import org.jasig.portlet.survey.service.jpa.JpaSurvey;
import org.jasig.portlet.survey.service.jpa.JpaSurveyQuestion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
class SurveyMapper
implements ISurveyMapper {
    @Autowired
    private Mapper beanMapper;
    @Autowired
    private IJpaSurveyDao jpaSurveyDao;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    SurveyMapper() {
    }

    public SurveyDTO toSurvey(JpaSurvey survey) {
        SurveyDTO result = (SurveyDTO)this.beanMapper.map((Object)survey, SurveyDTO.class);
        return result;
    }

    public JpaSurvey toJpaSurvey(SurveyDTO survey) {
        return (JpaSurvey)this.beanMapper.map((Object)survey, JpaSurvey.class);
    }

    public List<SurveyDTO> toSurveyList(List<JpaSurvey> jpaList) {
        return Lists.transform(jpaList, (Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<QuestionAnswerDTO> toQuestionAnswerList(List<JpaQuestionAnswer> jpaList) {
        return Lists.transform(jpaList, (Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    public QuestionDTO toQuestion(JpaQuestion question) {
        return (QuestionDTO)this.beanMapper.map((Object)question, QuestionDTO.class);
    }

    public JpaQuestion toJpaQuestion(QuestionDTO question) {
        return (JpaQuestion)this.beanMapper.map((Object)question, JpaQuestion.class);
    }

    public AnswerDTO toAnswer(JpaAnswer answer) {
        return (AnswerDTO)this.beanMapper.map((Object)answer, AnswerDTO.class);
    }

    public JpaAnswer toJpaAnswer(AnswerDTO answer) {
        return (JpaAnswer)this.beanMapper.map((Object)answer, JpaAnswer.class);
    }

    public QuestionAnswerDTO toQuestionAnswer(JpaQuestionAnswer qa) {
        return (QuestionAnswerDTO)this.beanMapper.map((Object)qa, QuestionAnswerDTO.class);
    }

    public JpaQuestionAnswer toJpaQuestionAnswer(QuestionAnswerDTO qa) {
        return (JpaQuestionAnswer)this.beanMapper.map((Object)qa, JpaQuestionAnswer.class);
    }

    public ResponseDTO toResponse(JpaResponse response) {
        this.log.debug(response.toString());
        ResponseDTO result = new ResponseDTO();
        result.setId(response.getId());
        result.setUser(response.getUser());
        result.setSurvey(response.getSurvey().getId());
        result.setLastUpdated(response.getLastUpdated());
        HashMap<Long, Boolean> multivalues = new HashMap<Long, Boolean>();
        for (JpaSurveyQuestion q : response.getSurvey().getJpaSurveyQuestions()) {
            multivalues.put(q.getId().getQuestionId(), q.getNumAllowedAnswers() > 1);
        }
        for (JpaResponseAnswer jpaResponseAnswer : response.getJpaResponseAnswers()) {
            ResponseAnswerDTO responseAnswer = new ResponseAnswerDTO();
            responseAnswer.setQuestion(Long.valueOf(jpaResponseAnswer.getId().getQuestionId()));
            responseAnswer.setMultiple((Boolean)multivalues.get(responseAnswer.getQuestion()));
            for (JpaAnswer answer : jpaResponseAnswer.getAnswer()) {
                responseAnswer.addAnswerId(Long.valueOf(answer.getId()));
            }
            result.addAnswer(responseAnswer);
        }
        result.setFeedback(response.getFeedback());
        return result;
    }

    public JpaResponse toJpaResponse(ResponseDTO response) {
        this.log.debug(response.toString());
        JpaResponse jpaResponse = new JpaResponse();
        jpaResponse.setId(response.getId());
        jpaResponse.setUser(response.getUser());
        jpaResponse.setSurvey(this.jpaSurveyDao.getSurvey(Long.valueOf(response.getSurvey())));
        for (ResponseAnswerDTO responseAnswer : response.getAnswers()) {
            JpaQuestion jpaQuestion = this.jpaSurveyDao.getQuestion(responseAnswer.getQuestion());
            JpaResponseAnswer jpaResponseAnswer = new JpaResponseAnswer();
            JpaResponseAnswerPK pk = new JpaResponseAnswerPK(jpaResponse, jpaQuestion);
            jpaResponseAnswer.setId(pk);
            for (Long answerId : responseAnswer.getAnswer()) {
                JpaAnswer jpaAnswer = this.jpaSurveyDao.getAnswer(answerId);
                jpaResponseAnswer.addJpaAnswer(jpaAnswer);
            }
            jpaResponse.addJpaResponseAnswer(jpaResponseAnswer);
        }
        jpaResponse.setFeedback(response.getFeedback());
        return jpaResponse;
    }

    public ResponseAnswerDTO toResponseAnswer(JpaResponseAnswer answer) {
        this.log.debug(answer.toString());
        ResponseAnswerDTO result = (ResponseAnswerDTO)this.beanMapper.map((Object)answer, ResponseAnswerDTO.class);
        return result;
    }

    public JpaResponseAnswer toJpaResponseAnswer(ResponseAnswerDTO answer) {
        this.log.debug(answer.toString());
        return (JpaResponseAnswer)this.beanMapper.map((Object)answer, JpaResponseAnswer.class);
    }

    public List<ResponseDTO> toResponseList(List<JpaResponse> responseList) {
        return Lists.transform(responseList, (Function)new /* Unavailable Anonymous Inner Class!! */);
    }
}

