/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.survey.service.report;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.jasig.portlet.survey.service.dto.SurveyDTO;
import org.jasig.portlet.survey.service.report.ISurveyReportGenerator;
import org.jasig.portlet.survey.service.report.ISurveyReportMapper;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class SurveyReportMapperImpl
implements ISurveyReportMapper,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private final List<ISurveyReportGenerator> generators = new ArrayList();

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void init() {
        Map beans = this.applicationContext.getBeansOfType(ISurveyReportGenerator.class);
        this.generators.addAll(beans.values());
        Collections.sort(this.generators, new /* Unavailable Anonymous Inner Class!! */);
    }

    public ISurveyReportGenerator getReportGenerator(SurveyDTO survey) {
        ISurveyReportGenerator rslt = null;
        for (ISurveyReportGenerator g : this.generators) {
            if (!g.appliesTo(survey)) continue;
            rslt = g;
            break;
        }
        return rslt;
    }
}

