/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.survey.service.jpa;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.jasig.portlet.survey.PublishedState;
import org.jasig.portlet.survey.service.jpa.JpaSurveyQuestion;

@Entity
@Table(name="SURVEY_SURVEY")
public class JpaSurvey
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="CANONICAL_NAME", nullable=true, unique=true)
    private String canonicalName;
    @Column(name="DESCRIPTION", nullable=true)
    private String description;
    @SequenceGenerator(name="SURVEY_SURVEY_GEN", sequenceName="SURVEY_SURVEY_SEQ", allocationSize=5)
    @TableGenerator(name="SURVEY_SURVEY_GEN", pkColumnValue="SURVEY_SURVEY", allocationSize=5)
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SURVEY_SURVEY_GEN")
    @Column(name="ID", updatable=false)
    private long id;
    @OneToMany(mappedBy="id.jpaSurvey", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private List<JpaSurveyQuestion> jpaSurveyQuestions;
    @Column(name="LAST_UPDATE_DATE", nullable=false)
    private Timestamp lastUpdateDate;
    @Column(name="LAST_UPDATE_USER", nullable=false)
    private String lastUpdateUser;
    @Column(name="STATUS", nullable=false)
    private PublishedState status;
    @Column(name="TEXT_KEY", nullable=true)
    private String textKey;
    @Column(name="TITLE", nullable=false)
    private String title;
    @Column(name="REQUIRE_APPROVAL", nullable=true)
    private Boolean requireApproval;

    public JpaSurveyQuestion addJpaSurveyQuestion(JpaSurveyQuestion jpaSurveyQuestion) {
        this.getJpaSurveyQuestions().add(jpaSurveyQuestion);
        jpaSurveyQuestion.getId().setJpaSurvey(this);
        return jpaSurveyQuestion;
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public String getDescription() {
        return this.description;
    }

    public long getId() {
        return this.id;
    }

    public List<JpaSurveyQuestion> getJpaSurveyQuestions() {
        return this.jpaSurveyQuestions;
    }

    public Timestamp getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public String getLastUpdateUser() {
        return this.lastUpdateUser;
    }

    public PublishedState getStatus() {
        return this.status;
    }

    public String getTextKey() {
        return this.textKey;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean getRequireApproval() {
        return this.requireApproval == null ? false : this.requireApproval;
    }

    public JpaSurveyQuestion removeJpaSurveyQuestion(JpaSurveyQuestion jpaSurveyQuestion) {
        this.getJpaSurveyQuestions().remove(jpaSurveyQuestion);
        jpaSurveyQuestion.getId().setJpaSurvey(null);
        return jpaSurveyQuestion;
    }

    public void setCanonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setJpaSurveyQuestions(List<JpaSurveyQuestion> jpaSurveyQuestions) {
        this.jpaSurveyQuestions = jpaSurveyQuestions;
    }

    public void setLastUpdateDate(Timestamp lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
    }

    public void setLastUpdateUser(String lastUpdateUser) {
        this.lastUpdateUser = lastUpdateUser;
    }

    public void setStatus(PublishedState status) {
        this.status = status;
    }

    public void setTextKey(String textKey) {
        this.textKey = textKey;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setRequireApproval(boolean approval) {
        this.requireApproval = approval;
    }
}

