/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.survey.mvc;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.security.Principal;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.jasig.portlet.survey.mvc.TextGroupImpl;
import org.jasig.portlet.survey.mvc.service.ISurveyDataService;
import org.jasig.portlet.survey.service.dto.ITextGroup;
import org.jasig.portlet.survey.service.dto.QuestionDTO;
import org.jasig.portlet.survey.service.dto.ResponseDTO;
import org.jasig.portlet.survey.service.dto.SurveyDTO;
import org.jasig.portlet.survey.service.dto.SurveyQuestionDTO;
import org.jasig.portlet.survey.service.dto.SurveySummaryDTO;
import org.jasig.portlet.survey.service.report.ISurveyReportGenerator;
import org.jasig.portlet.survey.service.report.ISurveyReportMapper;
import org.jsondoc.core.annotation.Api;
import org.jsondoc.core.annotation.ApiBodyObject;
import org.jsondoc.core.annotation.ApiMethod;
import org.jsondoc.core.annotation.ApiPathParam;
import org.jsondoc.core.annotation.ApiResponseObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Api(name="SurveyPortlet services", description="Methods for managing surveys")
@Controller
@RequestMapping(value={"/v1/surveys"}, produces={"application/json"})
public class SurveyRestController {
    public static final String REQUEST_ROOT = "/v1/surveys";
    @Autowired
    private ISurveyDataService dataService;
    @Autowired
    private ISurveyReportMapper reportMapper;
    @Resource(name="viewOtherUsersResponseRoles")
    private List<String> viewOtherUsersResponseRoles;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @PreAuthorize(value="hasRole('SURVEY_ADMIN')")
    @ApiMethod(description="Create a new question that is not associated with a survey.", responsestatuscode="201 - Created")
    @RequestMapping(method={RequestMethod.POST}, value={"/questions"})
    @ApiResponseObject
    public ResponseEntity<QuestionDTO> addQuestion(@ApiBodyObject @RequestBody QuestionDTO question) {
        QuestionDTO newQuestion = this.dataService.createQuestion(question);
        return new ResponseEntity((Object)newQuestion, HttpStatus.CREATED);
    }

    @PreAuthorize(value="hasRole('SURVEY_ADMIN')")
    @ApiMethod(description="Create a survey", responsestatuscode="201")
    @RequestMapping(method={RequestMethod.POST}, value={"/"})
    @ApiResponseObject
    public ResponseEntity<SurveyDTO> addSurvey(@ApiBodyObject @RequestBody SurveyDTO survey, Principal principal) {
        survey.setLastUpdateUser(principal.getName());
        SurveyDTO newSurvey = null;
        HttpStatus status = HttpStatus.CREATED;
        try {
            newSurvey = this.dataService.createSurvey(survey);
        }
        catch (Exception e) {
            status = HttpStatus.BAD_REQUEST;
            this.log.error("Error creating survey: " + survey.toString(), (Throwable)e);
        }
        return new ResponseEntity((Object)newSurvey, status);
    }

    @PreAuthorize(value="hasRole('SURVEY_ADMIN')")
    @ApiMethod(description="Create a text group", responsestatuscode="201")
    @RequestMapping(method={RequestMethod.POST}, value={"/textGroup"})
    @ApiResponseObject
    public ResponseEntity<ITextGroup> addTextGroup(@ApiBodyObject @RequestBody TextGroupImpl textGroup) {
        ITextGroup tg = this.dataService.createTextGroup((ITextGroup)textGroup);
        return new ResponseEntity((Object)tg, HttpStatus.CREATED);
    }

    @PreAuthorize(value="hasRole('SURVEY_USER')")
    @ApiMethod(description="Fetch all surveys", responsestatuscode="201")
    @RequestMapping(method={RequestMethod.GET}, value={"/"})
    @ApiResponseObject
    public ResponseEntity<List<SurveyDTO>> getAllSurveys() {
        this.log.debug("Get all surveys");
        List surveyDTOList = this.dataService.getAllSurveys();
        return new ResponseEntity((Object)surveyDTOList, HttpStatus.OK);
    }

    @PreAuthorize(value="hasRole('SURVEY_USER')")
    @ApiMethod(description="Fetch a survey by id", responsestatuscode="201")
    @RequestMapping(method={RequestMethod.GET}, value={"/{survey}"})
    @ApiResponseObject
    public ResponseEntity<SurveyDTO> getSurvey(@ApiPathParam(name="survey") @PathVariable Long survey) {
        this.log.debug("Get survey: " + survey);
        SurveyDTO surveyDTO = this.dataService.getSurvey(survey.longValue());
        return new ResponseEntity((Object)surveyDTO, HttpStatus.OK);
    }

    @PreAuthorize(value="hasRole('SURVEY_USER')")
    @ApiMethod(description="Fetch a survey by name", responsestatuscode="201")
    @RequestMapping(method={RequestMethod.GET}, value={"/surveyByName/{surveyName}"})
    public ResponseEntity<SurveyDTO> getSurvey(@ApiPathParam(name="surveyName") @PathVariable String surveyName) {
        this.log.debug("Get survey: " + surveyName);
        SurveyDTO surveyDTO = this.dataService.getSurveyByName(surveyName);
        return new ResponseEntity((Object)surveyDTO, HttpStatus.OK);
    }

    @PreAuthorize(value="hasRole('SURVEY_USER')")
    @ApiMethod
    @RequestMapping(method={RequestMethod.GET}, value={"/{survey}/questions"})
    public ResponseEntity<List<SurveyQuestionDTO>> getSurveyQuestions(@ApiPathParam(name="survey") @PathVariable Long survey) {
        this.log.debug("Get survey: " + survey);
        List sqList = this.dataService.getSurveyQuestions(survey);
        return new ResponseEntity((Object)sqList, HttpStatus.OK);
    }

    @PreAuthorize(value="hasRole('SURVEY_USER')")
    @ApiMethod(description="Fetch a text group by key", responsestatuscode="201")
    @RequestMapping(method={RequestMethod.GET}, value={"/textGroup/{textKey}"})
    public ResponseEntity<ITextGroup> getTextGroup(@PathVariable String textKey) {
        this.log.debug("Get text group by key: " + textKey);
        ITextGroup textGroup = this.dataService.getTextGroup(textKey);
        return new ResponseEntity((Object)textGroup, HttpStatus.OK);
    }

    @PreAuthorize(value="hasRole('SURVEY_ADMIN')")
    @ApiMethod(description="Associate an existing question to an existing survey", responsestatuscode="201")
    @RequestMapping(method={RequestMethod.POST}, value={"/{survey}/questions/{question}"})
    @ApiResponseObject
    public ResponseEntity<Boolean> linkQuestionToSurvey(@ApiPathParam(name="survey") @PathVariable Long survey, @ApiPathParam(name="question") @PathVariable Long question, @ApiBodyObject @RequestBody SurveyQuestionDTO surveyQuestion) {
        Boolean ret;
        HttpStatus status = HttpStatus.CREATED;
        try {
            ret = this.dataService.addQuestionToSurvey(survey, question, surveyQuestion);
        }
        catch (Exception e) {
            status = HttpStatus.BAD_REQUEST;
            ret = false;
            this.log.error("Error linking question to survey", (Throwable)e);
        }
        return new ResponseEntity((Object)ret, status);
    }

    @PreAuthorize(value="hasRole('SURVEY_ADMIN')")
    @ApiMethod(description="Update a question", responsestatuscode="201 - Created")
    @RequestMapping(method={RequestMethod.PUT}, value={"/questions/{questionId}"})
    public ResponseEntity<QuestionDTO> updateQuestion(@ApiPathParam(name="questionId") @PathVariable Long questionId, @ApiBodyObject @RequestBody QuestionDTO question) {
        HttpStatus status = HttpStatus.CREATED;
        QuestionDTO updatedQuestion = null;
        try {
            question.setId(questionId.longValue());
            updatedQuestion = this.dataService.updateQuestion(question);
            if (updatedQuestion == null) {
                status = HttpStatus.BAD_REQUEST;
            }
        }
        catch (Exception e) {
            status = HttpStatus.BAD_REQUEST;
            this.log.error("Error linking question to survey", (Throwable)e);
        }
        return new ResponseEntity((Object)updatedQuestion, status);
    }

    @PreAuthorize(value="hasRole('SURVEY_ADMIN')")
    @ApiMethod(description="Update survey", responsestatuscode="201 - Created")
    @RequestMapping(method={RequestMethod.PUT}, value={"/{surveyId}"})
    public ResponseEntity<SurveyDTO> updateSurvey(@ApiPathParam(name="surveyId") @PathVariable Long surveyId, @ApiBodyObject @RequestBody SurveyDTO survey, Principal principal) {
        survey.setLastUpdateUser(principal.getName());
        HttpStatus status = HttpStatus.CREATED;
        SurveyDTO updatedSurvey = null;
        try {
            survey.setId(surveyId.longValue());
            updatedSurvey = this.dataService.updateSurvey(survey);
            if (updatedSurvey == null) {
                status = HttpStatus.BAD_REQUEST;
            }
        }
        catch (Exception e) {
            status = HttpStatus.BAD_REQUEST;
            this.log.error("Error linking question to survey", (Throwable)e);
        }
        return new ResponseEntity((Object)updatedSurvey, status);
    }

    @PreAuthorize(value="hasRole('SURVEY_USER')")
    @ApiMethod(description="Fetch a user's answers for the specified survey", responsestatuscode="201")
    @RequestMapping(method={RequestMethod.GET}, value={"/surveyAnswers"})
    @ApiResponseObject
    public ResponseEntity<ResponseDTO> getResponseBySurveyAndUser(@RequestParam(value="survey") Long surveyId, HttpServletRequest req, Principal principal) {
        this.log.debug("GET surveyAnswers with survey = {}", (Object)surveyId);
        ResponseDTO responseDTO = null;
        try {
            responseDTO = this.dataService.getResponseByUserAndSurvey(principal.getName(), surveyId.longValue());
            this.log.debug(responseDTO != null ? responseDTO.toString() : "response is null");
        }
        catch (Exception e) {
            this.log.error("Error retrieving all survey responses for user: " + principal.getName() + ", survey: " + surveyId, (Throwable)e);
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity((Object)responseDTO, HttpStatus.OK);
    }

    @PreAuthorize(value="hasRole('SURVEY_USER')")
    @ApiMethod(description="Fetch a user's answers by id", responsestatuscode="201")
    @RequestMapping(method={RequestMethod.GET}, value={"/surveyAnswers/{responseId}"})
    @ApiResponseObject
    public ResponseEntity<ResponseDTO> getResponse(@ApiPathParam(name="responseId") @PathVariable Long responseId, HttpServletRequest req, Principal principal) {
        ResponseDTO responseDTO = this.dataService.getResponse(responseId.longValue());
        boolean allowed = false;
        if (principal.getName().equals(responseDTO.getUser())) {
            allowed = true;
        } else {
            for (String role : this.viewOtherUsersResponseRoles) {
                if (!req.isUserInRole(role)) continue;
                allowed = true;
                break;
            }
        }
        if (allowed) {
            return new ResponseEntity((Object)responseDTO, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.FORBIDDEN);
    }

    @PreAuthorize(value="hasRole('SURVEY_USER')")
    @ApiMethod(description="Create a user's response (answers)", responsestatuscode="201")
    @RequestMapping(method={RequestMethod.POST}, value={"/surveyAnswers"})
    @ApiResponseObject
    public ResponseEntity<ResponseDTO> addResponse(@ApiBodyObject @RequestBody ResponseDTO response, Principal principal) {
        response.setUser(principal.getName());
        ResponseDTO newResponse = null;
        HttpStatus status = HttpStatus.CREATED;
        try {
            newResponse = this.dataService.createResponse(response);
        }
        catch (Exception e) {
            status = HttpStatus.BAD_REQUEST;
            this.log.error("Error creating user" + principal.getName() + " response (answers): " + response.toString(), (Throwable)e);
        }
        return new ResponseEntity((Object)newResponse, status);
    }

    @PreAuthorize(value="hasRole('SURVEY_USER')")
    @ApiMethod(description="Update user's answers", responsestatuscode="201")
    @RequestMapping(method={RequestMethod.PUT}, value={"/surveyAnswers/{responseId}"})
    @ApiResponseObject
    public ResponseEntity<ResponseDTO> updateResponse(@ApiPathParam(name="responseId") @PathVariable Long responseId, @ApiBodyObject @RequestBody String body, HttpServletRequest req, Principal principal) {
        this.log.debug(body);
        HttpStatus status = HttpStatus.CREATED;
        ObjectMapper objectMapper = new ObjectMapper();
        ResponseDTO response = null;
        try {
            response = (ResponseDTO)objectMapper.readValue(body, ResponseDTO.class);
        }
        catch (IOException e) {
            status = HttpStatus.BAD_REQUEST;
            this.log.error("Error parsing update to survey answers with id = " + responseId, (Throwable)e);
            return new ResponseEntity((Object)response, status);
        }
        this.log.debug(response.toString());
        assert (responseId.longValue() == response.getId());
        ResponseDTO existingResponse = this.dataService.getResponse(responseId.longValue());
        if (existingResponse == null) {
            status = HttpStatus.BAD_REQUEST;
            this.log.error("Error no response with id = " + responseId);
            return new ResponseEntity((Object)response, status);
        }
        if (!existingResponse.getUser().equals(principal.getName())) {
            status = HttpStatus.BAD_REQUEST;
            this.log.error("Updated response user does not match existing response user");
            return new ResponseEntity((Object)response, status);
        }
        ResponseDTO updatedResponse = null;
        try {
            updatedResponse = this.dataService.updateResponse(response);
        }
        catch (Exception e) {
            status = HttpStatus.BAD_REQUEST;
            this.log.error("Error updating user" + principal.getName() + " response (answers): " + response.toString(), (Throwable)e);
        }
        return new ResponseEntity((Object)updatedResponse, status);
    }

    @PreAuthorize(value="hasRole('SURVEY_ADMIN')")
    @ApiMethod(description="Return summary of user response for a survey", responsestatuscode="201")
    @RequestMapping(method={RequestMethod.GET}, value={"/{survey}/summary"})
    @ApiResponseObject
    public ResponseEntity<SurveySummaryDTO> getSurveySummary(@ApiPathParam(name="survey") @PathVariable Long survey) {
        SurveySummaryDTO summaryDTO = this.dataService.getSurveySummary(survey);
        this.log.debug(summaryDTO.toString());
        return new ResponseEntity((Object)summaryDTO, HttpStatus.OK);
    }

    @PreAuthorize(value="hasRole('SURVEY_USER')")
    @ApiMethod(description="Fetch the post-survey report that was generated based on the user's answers", responsestatuscode="201")
    @RequestMapping(method={RequestMethod.GET}, value={"/surveyReport/{responseId}"})
    @ApiResponseObject
    public ModelAndView getSurveyReport(@ApiPathParam(name="responseId") @PathVariable Long responseId, HttpServletRequest req, Principal principal) {
        ResponseDTO response = this.dataService.getResponse(responseId.longValue());
        boolean allowed = false;
        if (principal.getName().equals(response.getUser())) {
            allowed = true;
        } else {
            for (String role : this.viewOtherUsersResponseRoles) {
                if (!req.isUserInRole(role)) continue;
                allowed = true;
                break;
            }
        }
        if (allowed) {
            SurveyDTO survey = this.dataService.getSurvey(response.getSurvey());
            ISurveyReportGenerator generator = this.reportMapper.getReportGenerator(survey);
            return generator.generateReport(survey, response);
        }
        throw new AccessDeniedException("Forbidden");
    }
}

