/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.survey.service.jpa;

import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Embeddable;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import org.jasig.portlet.survey.service.jpa.JpaAnswer;
import org.jasig.portlet.survey.service.jpa.JpaQuestion;

@Embeddable
public class JpaQuestionAnswerPK
implements Serializable {
    private static final long serialVersionUID = 1L;
    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.ALL})
    @JoinColumn(name="ANSWER_ID")
    private JpaAnswer jpaAnswer;
    @ManyToOne(cascade={CascadeType.PERSIST, CascadeType.ALL})
    @JoinColumn(name="QUESTION_ID")
    private JpaQuestion jpaQuestion;

    public JpaQuestionAnswerPK() {
    }

    public JpaQuestionAnswerPK(JpaAnswer answer, JpaQuestion question) {
        this.jpaAnswer = answer;
        this.jpaQuestion = question;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JpaQuestionAnswerPK)) {
            return false;
        }
        JpaQuestionAnswerPK castOther = (JpaQuestionAnswerPK)other;
        return this.getQuestionId() == castOther.getQuestionId() && this.getAnswerId() == castOther.getAnswerId();
    }

    public long getAnswerId() {
        return this.jpaAnswer.getId();
    }

    public long getQuestionId() {
        return this.jpaQuestion.getId();
    }

    public int hashCode() {
        int prime = 31;
        int hash = 17;
        hash = hash * 31 + (int)(this.getQuestionId() ^ this.getQuestionId() >>> 32);
        hash = hash * 31 + (int)(this.getAnswerId() ^ this.getAnswerId() >>> 32);
        return hash;
    }

    public JpaAnswer getJpaAnswer() {
        return this.jpaAnswer;
    }

    public void setJpaAnswer(JpaAnswer jpaAnswer) {
        this.jpaAnswer = jpaAnswer;
    }

    public JpaQuestion getJpaQuestion() {
        return this.jpaQuestion;
    }

    public void setJpaQuestion(JpaQuestion jpaQuestion) {
        this.jpaQuestion = jpaQuestion;
    }
}

