/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.survey.service.jpa;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.annotations.Type;
import org.jasig.portlet.survey.service.jpa.JpaResponseAnswer;
import org.jasig.portlet.survey.service.jpa.JpaSurvey;

@Entity
@NamedQueries(value={@NamedQuery(name="JpaResponse.findBySurvey", query="Select r from JpaResponse r where survey_id = ?1"), @NamedQuery(name="JpaResponse.findByUserAndSurvey", query="Select r from JpaResponse r where user = ?1 and survey_id = ?2"), @NamedQuery(name="JpaResponse.findByUser", query="Select r from JpaResponse r where user = ?1")})
@Table(name="SURVEY_RESPONSE")
public class JpaResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    @SequenceGenerator(name="SURVEY_RESPONSE_GEN", sequenceName="SURVEY_RESPONSE_SEQ", allocationSize=5)
    @TableGenerator(name="SURVEY_RESPONSE_GEN", pkColumnValue="SURVEY_RESPONSE", allocationSize=5)
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SURVEY_RESPONSE_GEN")
    @Column(name="ID", updatable=false)
    private long id;
    @Column(name="USER", nullable=false)
    private String user;
    @Column(name="LAST_UPDATED", nullable=false)
    private Date lastUpdated;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="SURVEY_ID")
    private JpaSurvey survey;
    @OneToMany(mappedBy="id.jpaResponse", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Set<JpaResponseAnswer> jpaResponseAnswers = new HashSet();
    @Lob
    @Type(type="org.hibernate.type.TextType")
    @Column(name="FEEDBACK")
    private String feedback;

    public long getId() {
        return this.id;
    }

    public String getUser() {
        return this.user;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public JpaSurvey getSurvey() {
        return this.survey;
    }

    public Set<JpaResponseAnswer> getJpaResponseAnswers() {
        return Collections.unmodifiableSet(this.jpaResponseAnswers);
    }

    public String getFeedback() {
        return this.feedback;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public void setSurvey(JpaSurvey survey) {
        this.survey = survey;
    }

    public void setJpaResponseAnswers(Set<JpaResponseAnswer> jpaResponseAnswers) {
        this.jpaResponseAnswers.clear();
        this.jpaResponseAnswers.addAll(jpaResponseAnswers);
    }

    public JpaResponseAnswer addJpaResponseAnswer(JpaResponseAnswer jpaResponseAnswer) {
        this.jpaResponseAnswers.add(jpaResponseAnswer);
        jpaResponseAnswer.getId().setJpaResponse(this);
        return jpaResponseAnswer;
    }

    public JpaResponseAnswer removeJpaResponseAnswer(JpaResponseAnswer jpaResponseAnswer) {
        this.jpaResponseAnswers.remove(jpaResponseAnswer);
        jpaResponseAnswer.getId().setJpaResponse(null);
        return jpaResponseAnswer;
    }

    public void setFeedback(String fb) {
        this.feedback = fb;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("Id", this.id).append("user", (Object)this.user).append("answer count", this.getJpaResponseAnswers().size()).toString();
    }
}

