/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.survey.service.jpa;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.jasig.portlet.survey.service.jpa.IJpaSurveyDao;
import org.jasig.portlet.survey.service.jpa.JpaAnswer;
import org.jasig.portlet.survey.service.jpa.JpaQuestion;
import org.jasig.portlet.survey.service.jpa.JpaQuestionAnswer;
import org.jasig.portlet.survey.service.jpa.JpaResponse;
import org.jasig.portlet.survey.service.jpa.JpaSurvey;
import org.jasig.portlet.survey.service.jpa.JpaSurveyQuestion;
import org.jasig.portlet.survey.service.jpa.JpaSurveyQuestionPK;
import org.jasig.portlet.survey.service.jpa.JpaSurveyText;
import org.jasig.portlet.survey.service.jpa.repo.JpaAnswerRepository;
import org.jasig.portlet.survey.service.jpa.repo.JpaQuestionAnswerRepository;
import org.jasig.portlet.survey.service.jpa.repo.JpaQuestionRepository;
import org.jasig.portlet.survey.service.jpa.repo.JpaResponseAnswerRepository;
import org.jasig.portlet.survey.service.jpa.repo.JpaResponseRepository;
import org.jasig.portlet.survey.service.jpa.repo.JpaSurveyQuestionRepository;
import org.jasig.portlet.survey.service.jpa.repo.JpaSurveyRepository;
import org.jasig.portlet.survey.service.jpa.repo.JpaSurveyTextRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
class JpaSurveyDao
implements IJpaSurveyDao {
    @Autowired
    private JpaAnswerRepository answerRepository;
    @Autowired
    private JpaQuestionAnswerRepository qaRepository;
    @Autowired
    private JpaQuestionRepository questionRepository;
    @Autowired
    private JpaSurveyQuestionRepository surveyQuestionRepository;
    @Autowired
    private JpaSurveyRepository surveyRepository;
    @Autowired
    private JpaResponseRepository responseRepository;
    @Autowired
    private JpaResponseAnswerRepository responseAnswerRepository;
    @Autowired
    private JpaSurveyTextRepository surveyTextRepository;

    JpaSurveyDao() {
    }

    public JpaSurveyQuestion attachQuestionToSurvey(Long surveyId, Long questionId, JpaSurveyQuestion surveyQuestion) {
        JpaSurvey survey = this.getSurvey(surveyId);
        JpaQuestion question = this.getQuestion(questionId);
        survey.setLastUpdateDate(new Timestamp(new Date().getTime()));
        JpaSurveyQuestionPK pk = new JpaSurveyQuestionPK(question, survey);
        surveyQuestion.setId(pk);
        survey.addJpaSurveyQuestion(surveyQuestion);
        this.surveyRepository.save((Object)survey);
        return surveyQuestion;
    }

    public JpaAnswer createAnswer(JpaAnswer answer) {
        JpaAnswer newAnswer = (JpaAnswer)this.answerRepository.save((Object)answer);
        return newAnswer;
    }

    public JpaQuestion createQuestion(JpaQuestion question) {
        this.setupQuestionForSave(question, true);
        JpaQuestion q = (JpaQuestion)this.questionRepository.save((Object)question);
        return q;
    }

    public JpaQuestionAnswer createQuestionAnswer(JpaQuestion question, JpaAnswer answer, Integer sequence) {
        JpaQuestionAnswer newQa = new JpaQuestionAnswer();
        newQa.getId().setJpaAnswer(answer);
        newQa.getId().setJpaQuestion(question);
        newQa = (JpaQuestionAnswer)this.qaRepository.save((Object)newQa);
        return newQa;
    }

    public JpaSurvey createSurvey(JpaSurvey survey) {
        List sqList = survey.getJpaSurveyQuestions();
        if (sqList != null && !sqList.isEmpty()) {
            for (JpaSurveyQuestion sq : sqList) {
                sq.getId().setJpaSurvey(survey);
                JpaQuestion q = sq.getId().getJpaQuestion();
                this.setupQuestionForSave(q, true);
                q = this.createQuestion(q);
                sq.getId().setJpaQuestion(q);
            }
        }
        JpaSurvey s = (JpaSurvey)this.surveyRepository.save((Object)survey);
        return s;
    }

    public JpaSurveyText createSurveyText(JpaSurveyText text) {
        JpaSurveyText newSurveyText = (JpaSurveyText)this.surveyTextRepository.save((Object)text);
        return newSurveyText;
    }

    public List<JpaSurvey> getAllSurveys() {
        Iterable surveyIter = this.surveyRepository.findAll();
        List surveyList = IteratorUtils.toList(surveyIter.iterator());
        return surveyList;
    }

    public JpaQuestion getQuestion(Long id) {
        JpaQuestion question = (JpaQuestion)this.questionRepository.findOne((Serializable)id);
        return question;
    }

    public JpaAnswer getAnswer(Long id) {
        JpaAnswer answer = (JpaAnswer)this.answerRepository.findOne((Serializable)id);
        return answer;
    }

    public JpaSurvey getSurvey(Long id) {
        Validate.isTrue((id > 0L ? 1 : 0) != 0, (String)("Invalid survey id: " + id));
        JpaSurvey survey = (JpaSurvey)this.surveyRepository.findOne((Serializable)id);
        return survey;
    }

    public JpaSurvey getSurveyByCanonicalName(String canonicalName) {
        if (StringUtils.isEmpty((String)canonicalName)) {
            return null;
        }
        return this.surveyRepository.findByCanonicalName(canonicalName);
    }

    public JpaSurveyText getText(String key, String variant) {
        if (StringUtils.isEmpty((String)key)) {
            return new JpaSurveyText();
        }
        JpaSurveyText result = this.surveyTextRepository.findByKeyAndVariant(key, StringUtils.trimToEmpty((String)variant));
        return result == null ? new JpaSurveyText() : result;
    }

    private void setupQuestionForSave(JpaQuestion jpaQuestion, boolean createAnswer) {
        Set qaList = jpaQuestion.getJpaQuestionAnswers();
        if (qaList != null && !qaList.isEmpty()) {
            for (JpaQuestionAnswer qa : qaList) {
                JpaAnswer answer = qa.getId().getJpaAnswer();
                this.createAnswer(answer);
                qa.getId().setJpaQuestion(jpaQuestion);
                qa.getId().setJpaAnswer(answer);
                if (jpaQuestion.getId() == 0L) continue;
                JpaQuestionAnswer existingQA = (JpaQuestionAnswer)this.qaRepository.findOne((Serializable)qa.getId());
                if (existingQA != null) {
                    existingQA.setSequence(qa.getSequence());
                    existingQA.setLogic(qa.getLogic());
                    existingQA.setCanonicalName(qa.getCanonicalName());
                    this.qaRepository.save((Object)existingQA);
                    continue;
                }
                this.qaRepository.save((Object)qa);
            }
        }
    }

    public JpaQuestion updateQuestion(JpaQuestion question) {
        this.setupQuestionForSave(question, false);
        return (JpaQuestion)this.questionRepository.save((Object)question);
    }

    public JpaSurvey updateSurvey(JpaSurvey survey) {
        return (JpaSurvey)this.surveyRepository.save((Object)survey);
    }

    public JpaResponse createResponse(JpaResponse jpaResponse) {
        return (JpaResponse)this.responseRepository.save((Object)jpaResponse);
    }

    public JpaResponse getResponse(long id) {
        return (JpaResponse)this.responseRepository.findOne((Serializable)Long.valueOf(id));
    }

    public List<JpaResponse> getResponseByUser(String user) {
        List responseIter = this.responseRepository.findByUser(user);
        return IteratorUtils.toList(responseIter.iterator());
    }

    public JpaResponse getResponseByUserAndSurvey(String user, long surveyId) {
        List responseIter = this.responseRepository.findByUserAndSurvey(user, Long.valueOf(surveyId));
        return responseIter.iterator().hasNext() ? (JpaResponse)responseIter.iterator().next() : null;
    }

    public JpaResponse updateResponse(JpaResponse jpaResponse) {
        return (JpaResponse)this.responseRepository.save((Object)jpaResponse);
    }

    public List<JpaResponse> getResponseBySurvey(Long surveyId) {
        return this.responseRepository.findBySurvey(surveyId);
    }
}

