/*
 * Copyright(c) Brigham Young University, 2008.  All rights reserved.
 * (See licensing and redistribution disclosures in licensing project directory.)
 * 
 */
package org.jasig.portlet.search.ldap;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * This Person class represents a person found via directory search.  The Person
 * is comprised of a full name used for display purposes and a map of all other 
 * visible attributes.
 * 
 * @author Jen Bourey
 * @version $Revision: 44239 $
 */
public class Person {
	
	private String fullName;
	private Map<String,String> attributes = new LinkedHashMap<String,String>();

	/**
	 * Get the full display name of this Person.
	 * 
	 * @return full name
	 */
	public String getFullName() {
		return fullName;
	}
	
	/**
	 * Set the full display name of this Person.
	 * 
	 * @param fullName
	 */
	public void setFullName(String fullName) {
		this.fullName = fullName;
	}
	
	/**
	 * Get a map of attributes for this Person.
	 * 
	 * @return attributes
	 */
	public Map<String, String> getAttributes() {
		return attributes;
	}
	
	/**
	 * Set the map of attributes for this Person.  Mapped attributes
	 * should represent all visible properties of the person except
	 * the full name.
	 * 
	 * @param attributes
	 */
	public void setAttributes(Map<String, String> attributes) {
		this.attributes = attributes;
	}
	
	/**
	 * Set an individual attribute for this Person.
	 * 
	 * @param key		name of the Person attribute to set
	 * @param value		attribute value
	 */
	public void put(String key, String value) {
		this.attributes.put(key, value);
	}
	
	/**
	 * Get an individual attribute for this Person.
	 * 
	 * @param key		name of the Person attribute to retrieve
	 * @return			attribute value
	 */
	public String get(String key) {
		return this.attributes.get(key);
	}
	
}
