/*
 * Copyright(c) Yale University, 2008.  All rights reserved.
 * (See licensing and redistribution disclosures in licensing project directory.)
 * 
 */
package org.jasig.portlet.search.mvc;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

/**
 * GoogleSearchFrameController constructs data for a google search IFrame.
 * 
 * @author Jen Bourey
 * @version $Revision: 46646 $
 */
public class GoogleSearchFrameController extends AbstractController {

	private static Log log = LogFactory.getLog(GoogleSearchFrameController.class);
	private Map<String,String> googleKeys;
	
	/*
	 * (non-Javadoc)
	 * @see org.springframework.web.servlet.mvc.AbstractController#handleRequestInternal(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	@Override
	protected ModelAndView handleRequestInternal(HttpServletRequest request,
			HttpServletResponse arg1) throws Exception {

		// find the appropriate google key for this server
		String serverAddress = request.getServerName();
		if (request.getServerPort() != 80 && request.getServerPort() != 443)
			serverAddress = serverAddress.concat(":" + request.getServerPort());
		log.debug("retrieving google key for server " + serverAddress);
		log.debug("found key " + googleKeys.get(serverAddress));

		Map<String, Object> model = new HashMap<String, Object>();
		model.put("googleKey", (String) googleKeys.get(serverAddress));
		
		return new ModelAndView("/googleSearchFrame", "model", model);
	}

	/**
	 * Set a map of Google search API keys to use.  Map keys should be 
	 * of the format host[:port] and should map to the appropriate API 
	 * key for that server.
	 * 
	 * @param keys
	 */
	public void setGoogleKeys(Map<String,String> keys) {
		this.googleKeys = keys;
	}
	
}
