/*
 * Copyright(c) Brigham Young University, 2008.  All rights reserved.
 * (See licensing and redistribution disclosures in licensing project directory.)
 * 
 */
package org.jasig.portlet.search.mvc;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Source;

import org.springframework.web.servlet.view.xslt.AbstractXsltView;

/**
 * GsaXsltView is a simple extension of the AbstractXsltView that retrieves
 * a Source object from the supplied Model. 
 * 
 * @author Jen Bourey
 * @version $Revision: 46646 $
 */
public class GsaXsltView extends AbstractXsltView {
	
	/*
	 * (non-Javadoc)
	 * @see org.springframework.web.servlet.view.xslt.AbstractXsltView#createXsltSource(java.util.Map, java.lang.String, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	@Override
	protected Source createXsltSource(Map model, String root,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		Map map = (Map) model.get("model");
		Source source = (Source) map.get("source");
		return source;
	}

	/*
	 * (non-Javadoc)
	 * @see org.springframework.web.servlet.view.xslt.AbstractXsltView#getParameters(java.util.Map, javax.servlet.http.HttpServletRequest)
	 */
	@Override
	protected Map getParameters(Map model, HttpServletRequest request) {
		Map map = new HashMap();
		map.put("stylesheet", ((Map) model.get("model")).get("googleStylesheet"));
		map.put("googleBaseUrl", ((Map) model.get("model")).get("googleBaseUrl"));
		return map;
	}

}
