/*
 * Copyright(c) Brigham Young University, 2008.  All rights reserved.
 * (See licensing and redistribution disclosures in licensing project directory.)
 * 
 */
package org.jasig.portlet.search.mvc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.search.ldap.LdapSearchServiceImpl;
import org.jasig.portlet.search.ldap.Person;
import org.springframework.ldap.LimitExceededException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

/**
 * PersonSearchController performs directory searches for person information
 * against an LDAP directory.
 * 
 * @author Jen Bourey
 */
public class PersonSearchController extends AbstractController {

	private static Log log = LogFactory.getLog(PersonSearchController.class);
	private LdapSearchServiceImpl personSearchService;

	/*
	 * (non-Javadoc)
	 * @see org.springframework.web.servlet.mvc.AbstractController#handleRequestInternal(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	@Override
	protected ModelAndView handleRequestInternal(HttpServletRequest request,
			HttpServletResponse response) throws Exception {

		Map<String, Object> model = new HashMap<String, Object>();

		// if this is a logged in user, use the logged-in attributes
		// mapper.  otherwise, use the potentially more limited
		// guest attributes mapper
		HttpSession session = request.getSession();
		Object loggedIn = session.getAttribute("loggedIn");
		boolean isLoggedIn = false;
		if (loggedIn != null && (Boolean) loggedIn)
			isLoggedIn = true;
		
		// perform the search
		List<Person> people = null;
		try {
			people = personSearchService.searchDirectory(request.getParameter("name"), isLoggedIn);
		} catch (LimitExceededException e) {
			model.put("sizeLimitExceeded", true);
			if (log.isDebugEnabled()) {
				log.debug("LDAP search size limit exceeded for search '" 
						+ request.getParameter("name") + "'");
			}
		}

		// add our list of people to the model and return the model and view
		model.put("people", people);
		return new ModelAndView("/ldapSearch", "model", model);
	}
	

	public void setPersonSearchService(LdapSearchServiceImpl searchService) {
		this.personSearchService = searchService;
	}
	
	
}
